/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.artemis.autoconfigure;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.artemis.autoconfigure.ArtemisMode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.jms.autoconfigure.JmsPoolConnectionFactoryProperties;

@ConfigurationProperties(value="spring.artemis")
public class ArtemisProperties {
    private @Nullable ArtemisMode mode;
    private @Nullable String brokerUrl;
    private @Nullable String user;
    private @Nullable String password;
    private final Embedded embedded = new Embedded();
    @NestedConfigurationProperty
    private final JmsPoolConnectionFactoryProperties pool = new JmsPoolConnectionFactoryProperties();

    public @Nullable ArtemisMode getMode() {
        return this.mode;
    }

    public void setMode(@Nullable ArtemisMode mode) {
        this.mode = mode;
    }

    public @Nullable String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(@Nullable String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public @Nullable String getUser() {
        return this.user;
    }

    public void setUser(@Nullable String user) {
        this.user = user;
    }

    public @Nullable String getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public Embedded getEmbedded() {
        return this.embedded;
    }

    public JmsPoolConnectionFactoryProperties getPool() {
        return this.pool;
    }

    public static class Embedded {
        private static final AtomicInteger serverIdCounter = new AtomicInteger();
        private int serverId = serverIdCounter.getAndIncrement();
        private boolean enabled = true;
        private boolean persistent;
        private @Nullable String dataDirectory;
        private String[] queues = new String[0];
        private String[] topics = new String[0];
        private String clusterPassword = UUID.randomUUID().toString();
        private boolean defaultClusterPassword = true;

        public int getServerId() {
            return this.serverId;
        }

        public void setServerId(int serverId) {
            this.serverId = serverId;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public void setPersistent(boolean persistent) {
            this.persistent = persistent;
        }

        public @Nullable String getDataDirectory() {
            return this.dataDirectory;
        }

        public void setDataDirectory(@Nullable String dataDirectory) {
            this.dataDirectory = dataDirectory;
        }

        public String[] getQueues() {
            return this.queues;
        }

        public void setQueues(String[] queues) {
            this.queues = queues;
        }

        public String[] getTopics() {
            return this.topics;
        }

        public void setTopics(String[] topics) {
            this.topics = topics;
        }

        public String getClusterPassword() {
            return this.clusterPassword;
        }

        public void setClusterPassword(String clusterPassword) {
            this.clusterPassword = clusterPassword;
            this.defaultClusterPassword = false;
        }

        public boolean isDefaultClusterPassword() {
            return this.defaultClusterPassword;
        }

        public Map<String, Object> generateTransportParameters() {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("serverId", this.getServerId());
            return parameters;
        }
    }
}

