/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.testcontainers;

import org.springframework.boot.amqp.autoconfigure.RabbitStreamConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.rabbitmq.RabbitMQContainer;

class RabbitStreamContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<RabbitMQContainer, RabbitStreamConnectionDetails> {
    RabbitStreamContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, new String[]{"org.springframework.rabbit.stream.producer.RabbitStreamTemplate"});
    }

    protected boolean sourceAccepts(ContainerConnectionSource<RabbitMQContainer> source, Class<?> requiredContainerType, Class<?> requiredConnectionDetailsType) {
        return source.getConnectionDetailsTypes().contains(requiredConnectionDetailsType) && super.sourceAccepts(source, requiredContainerType, requiredConnectionDetailsType);
    }

    protected RabbitStreamConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<RabbitMQContainer> source) {
        return new RabbitMqStreamContainerConnectionDetails(source);
    }

    static final class RabbitMqStreamContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<RabbitMQContainer>
    implements RabbitStreamConnectionDetails {
        private RabbitMqStreamContainerConnectionDetails(ContainerConnectionSource<RabbitMQContainer> source) {
            super(source);
        }

        @Override
        public String getHost() {
            return ((RabbitMQContainer)this.getContainer()).getHost();
        }

        @Override
        public int getPort() {
            return ((RabbitMQContainer)this.getContainer()).getMappedPort(5552);
        }

        @Override
        public String getUsername() {
            return ((RabbitMQContainer)this.getContainer()).getAdminUsername();
        }

        @Override
        public String getPassword() {
            return ((RabbitMQContainer)this.getContainer()).getAdminPassword();
        }
    }
}

