/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.autoconfigure;

import com.rabbitmq.stream.Environment;
import com.rabbitmq.stream.EnvironmentBuilder;
import org.springframework.amqp.rabbit.config.ContainerCustomizer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.amqp.autoconfigure.EnvironmentBuilderCustomizer;
import org.springframework.boot.amqp.autoconfigure.RabbitConnectionDetails;
import org.springframework.boot.amqp.autoconfigure.RabbitProperties;
import org.springframework.boot.amqp.autoconfigure.RabbitStreamTemplateConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.rabbit.stream.config.StreamRabbitListenerContainerFactory;
import org.springframework.rabbit.stream.listener.ConsumerCustomizer;
import org.springframework.rabbit.stream.listener.StreamListenerContainer;
import org.springframework.rabbit.stream.micrometer.RabbitStreamListenerObservationConvention;
import org.springframework.rabbit.stream.micrometer.RabbitStreamTemplateObservationConvention;
import org.springframework.rabbit.stream.producer.ProducerCustomizer;
import org.springframework.rabbit.stream.producer.RabbitStreamOperations;
import org.springframework.rabbit.stream.producer.RabbitStreamTemplate;
import org.springframework.rabbit.stream.support.converter.StreamMessageConverter;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={StreamRabbitListenerContainerFactory.class})
class RabbitStreamConfiguration {
    RabbitStreamConfiguration() {
    }

    @Bean(name={"rabbitListenerContainerFactory"})
    @ConditionalOnMissingBean(name={"rabbitListenerContainerFactory"})
    @ConditionalOnProperty(name={"spring.rabbitmq.listener.type"}, havingValue="stream")
    StreamRabbitListenerContainerFactory streamRabbitListenerContainerFactory(Environment rabbitStreamEnvironment, RabbitProperties properties, ObjectProvider<ConsumerCustomizer> consumerCustomizer, ObjectProvider<ContainerCustomizer<StreamListenerContainer>> containerCustomizer, ObjectProvider<RabbitStreamListenerObservationConvention> observationConvention) {
        StreamRabbitListenerContainerFactory factory = new StreamRabbitListenerContainerFactory(rabbitStreamEnvironment);
        RabbitProperties.StreamContainer stream = properties.getListener().getStream();
        factory.setObservationEnabled(stream.isObservationEnabled());
        factory.setNativeListener(stream.isNativeListener());
        observationConvention.ifUnique(arg_0 -> ((StreamRabbitListenerContainerFactory)factory).setStreamListenerObservationConvention(arg_0));
        consumerCustomizer.ifUnique(arg_0 -> ((StreamRabbitListenerContainerFactory)factory).setConsumerCustomizer(arg_0));
        containerCustomizer.ifUnique(arg_0 -> ((StreamRabbitListenerContainerFactory)factory).setContainerCustomizer(arg_0));
        return factory;
    }

    @Bean(name={"rabbitStreamEnvironment"})
    @ConditionalOnMissingBean(name={"rabbitStreamEnvironment"})
    Environment rabbitStreamEnvironment(RabbitProperties properties, RabbitConnectionDetails connectionDetails, ObjectProvider<EnvironmentBuilderCustomizer> customizers) {
        EnvironmentBuilder builder = RabbitStreamConfiguration.configure(Environment.builder(), properties, connectionDetails);
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    RabbitStreamTemplateConfigurer rabbitStreamTemplateConfigurer(RabbitProperties properties, ObjectProvider<MessageConverter> messageConverter, ObjectProvider<StreamMessageConverter> streamMessageConverter, ObjectProvider<ProducerCustomizer> producerCustomizer, ObjectProvider<RabbitStreamTemplateObservationConvention> observationConvention) {
        RabbitStreamTemplateConfigurer configurer = new RabbitStreamTemplateConfigurer();
        configurer.setMessageConverter((MessageConverter)messageConverter.getIfUnique());
        configurer.setStreamMessageConverter((StreamMessageConverter)streamMessageConverter.getIfUnique());
        configurer.setProducerCustomizer((ProducerCustomizer)producerCustomizer.getIfUnique());
        configurer.setObservationConvention((RabbitStreamTemplateObservationConvention)observationConvention.getIfUnique());
        return configurer;
    }

    @Bean
    @ConditionalOnMissingBean(value={RabbitStreamOperations.class})
    @ConditionalOnProperty(name={"spring.rabbitmq.stream.name"})
    RabbitStreamTemplate rabbitStreamTemplate(Environment rabbitStreamEnvironment, RabbitProperties properties, RabbitStreamTemplateConfigurer configurer) {
        String name = properties.getStream().getName();
        Assert.state((name != null ? 1 : 0) != 0, (String)"'name' must not be null");
        RabbitStreamTemplate template = new RabbitStreamTemplate(rabbitStreamEnvironment, name);
        configurer.configure(template);
        return template;
    }

    static EnvironmentBuilder configure(EnvironmentBuilder builder, RabbitProperties properties, RabbitConnectionDetails connectionDetails) {
        return RabbitStreamConfiguration.configure(builder, properties.getStream(), connectionDetails);
    }

    private static EnvironmentBuilder configure(EnvironmentBuilder builder, RabbitProperties.Stream stream, RabbitConnectionDetails connectionDetails) {
        builder.lazyInitialization(true);
        PropertyMapper map = PropertyMapper.get();
        map.from((Object)stream.getHost()).to(arg_0 -> ((EnvironmentBuilder)builder).host(arg_0));
        map.from((Object)stream.getPort()).to(arg_0 -> ((EnvironmentBuilder)builder).port(arg_0));
        map.from((Object)stream.getVirtualHost()).orFrom(connectionDetails::getVirtualHost).to(arg_0 -> ((EnvironmentBuilder)builder).virtualHost(arg_0));
        map.from((Object)stream.getUsername()).orFrom(connectionDetails::getUsername).to(arg_0 -> ((EnvironmentBuilder)builder).username(arg_0));
        map.from((Object)stream.getPassword()).orFrom(connectionDetails::getPassword).to(arg_0 -> ((EnvironmentBuilder)builder).password(arg_0));
        return builder;
    }
}

