/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.ApiVersion;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.health.Contributor;
import org.springframework.boot.actuate.health.HealthDescriptor;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroup;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.HealthEndpointSupport;
import org.springframework.boot.actuate.health.HealthEndpointWebExtensionRuntimeHints;
import org.springframework.boot.actuate.health.IndicatedHealthDescriptor;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.registry.HealthContributorRegistry;
import org.springframework.boot.health.registry.ReactiveHealthContributorRegistry;
import org.springframework.context.annotation.ImportRuntimeHints;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@EndpointWebExtension(endpoint=HealthEndpoint.class)
@ImportRuntimeHints(value={HealthEndpointWebExtensionRuntimeHints.class})
public class ReactiveHealthEndpointWebExtension
extends HealthEndpointSupport<Mono<? extends Health>, Mono<? extends HealthDescriptor>> {
    public ReactiveHealthEndpointWebExtension(ReactiveHealthContributorRegistry registry, @Nullable HealthContributorRegistry fallbackRegistry, HealthEndpointGroups groups, @Nullable Duration slowContributorLoggingThreshold) {
        super(Contributor.reactive(registry, fallbackRegistry), groups, slowContributorLoggingThreshold);
    }

    @ReadOperation
    public Mono<WebEndpointResponse<? extends HealthDescriptor>> health(ApiVersion apiVersion, @Nullable WebServerNamespace serverNamespace, SecurityContext securityContext) {
        return this.health(apiVersion, serverNamespace, securityContext, false, EMPTY_PATH);
    }

    @ReadOperation
    public Mono<WebEndpointResponse<? extends HealthDescriptor>> health(ApiVersion apiVersion, @Nullable WebServerNamespace serverNamespace, SecurityContext securityContext, String ... path) {
        return this.health(apiVersion, serverNamespace, securityContext, false, path);
    }

    public Mono<WebEndpointResponse<? extends HealthDescriptor>> health(ApiVersion apiVersion, @Nullable WebServerNamespace serverNamespace, SecurityContext securityContext, boolean showAll, String ... path) {
        HealthEndpointSupport.Result result = this.getResult(apiVersion, serverNamespace, securityContext, showAll, path);
        if (result == null) {
            return Arrays.equals(path, EMPTY_PATH) ? Mono.just(new WebEndpointResponse<IndicatedHealthDescriptor>(IndicatedHealthDescriptor.UP, 200)) : Mono.just(new WebEndpointResponse<int>(404));
        }
        HealthEndpointGroup group = result.group();
        return ((Mono)result.descriptor()).map(health -> {
            int statusCode = group.getHttpCodeStatusMapper().getStatusCode(health.getStatus());
            return new WebEndpointResponse<HealthDescriptor>((HealthDescriptor)health, statusCode);
        });
    }

    @Override
    protected Mono<? extends HealthDescriptor> aggregateDescriptors(ApiVersion apiVersion, Map<String, Mono<? extends HealthDescriptor>> contributions, StatusAggregator statusAggregator, boolean showComponents, @Nullable Set<String> groupNames) {
        return Flux.fromIterable(contributions.entrySet()).flatMap(NamedHealthDescriptor::create).collectMap(NamedHealthDescriptor::name, NamedHealthDescriptor::descriptor).map(components -> this.getCompositeDescriptor(apiVersion, (Map<String, HealthDescriptor>)components, statusAggregator, showComponents, groupNames));
    }

    private record NamedHealthDescriptor(String name, HealthDescriptor descriptor) {
        static Mono<NamedHealthDescriptor> create(Map.Entry<String, Mono<? extends HealthDescriptor>> entry) {
            Mono name = Mono.just((Object)entry.getKey());
            Mono<? extends HealthDescriptor> health = entry.getValue();
            return Mono.zip(NamedHealthDescriptor::ofPair, (Mono[])new Mono[]{name, health});
        }

        private static NamedHealthDescriptor ofPair(Object ... pair) {
            return new NamedHealthDescriptor((String)pair[0], (HealthDescriptor)pair[1]);
        }
    }
}

