/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.ApiVersion;
import org.springframework.boot.actuate.health.HealthDescriptor;
import org.springframework.boot.health.contributor.Status;
import org.springframework.util.Assert;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class CompositeHealthDescriptor
extends HealthDescriptor {
    private final ApiVersion apiVersion;
    private final Status status;
    private final @Nullable Map<String, HealthDescriptor> components;

    CompositeHealthDescriptor(ApiVersion apiVersion, Status status, @Nullable Map<String, HealthDescriptor> components) {
        Assert.notNull((Object)apiVersion, (String)"'apiVersion' must not be null");
        Assert.notNull((Object)status, (String)"'status' must not be null");
        this.apiVersion = apiVersion;
        this.status = status;
        this.components = components != null ? new TreeMap(components) : components;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @Nullable Map<String, HealthDescriptor> getComponents() {
        return this.apiVersion == ApiVersion.V3 ? this.components : null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @Nullable Map<String, HealthDescriptor> getDetails() {
        return this.apiVersion == ApiVersion.V2 ? this.components : null;
    }
}

