/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.invoke.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.invoke.OperationParameter;
import org.springframework.boot.actuate.endpoint.invoke.OperationParameters;
import org.springframework.boot.actuate.endpoint.invoke.reflect.OperationMethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.Assert;

class OperationMethodParameters
implements OperationParameters {
    private final List<OperationParameter> operationParameters;

    OperationMethodParameters(Method method, ParameterNameDiscoverer parameterNameDiscoverer) {
        Assert.notNull((Object)method, (String)"'method' must not be null");
        Assert.notNull((Object)parameterNameDiscoverer, (String)"'parameterNameDiscoverer' must not be null");
        @Nullable String[] parameterNames = parameterNameDiscoverer.getParameterNames(method);
        Parameter[] parameters = method.getParameters();
        Assert.state((parameterNames != null ? 1 : 0) != 0, () -> "Failed to extract parameter names for " + String.valueOf(method));
        this.operationParameters = this.getOperationParameters(parameters, parameterNames);
    }

    private List<OperationParameter> getOperationParameters(Parameter[] parameters, @Nullable String[] names) {
        ArrayList<OperationMethodParameter> operationParameters = new ArrayList<OperationMethodParameter>(parameters.length);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Assert.state((name != null ? 1 : 0) != 0, (String)"'name' must not be null");
            operationParameters.add(new OperationMethodParameter(name, parameters[i]));
        }
        return Collections.unmodifiableList(operationParameters);
    }

    @Override
    public int getParameterCount() {
        return this.operationParameters.size();
    }

    @Override
    public OperationParameter get(int index) {
        return this.operationParameters.get(index);
    }

    @Override
    public Iterator<OperationParameter> iterator() {
        return this.operationParameters.iterator();
    }

    @Override
    public Stream<OperationParameter> stream() {
        return this.operationParameters.stream();
    }
}

