/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.management;

import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@WebEndpoint(id="heapdump")
public class HeapDumpWebEndpoint {
    private final long timeout;
    private final Lock lock = new ReentrantLock();
    private HeapDumper heapDumper;

    public HeapDumpWebEndpoint() {
        this(TimeUnit.SECONDS.toMillis(10L));
    }

    protected HeapDumpWebEndpoint(long timeout) {
        this.timeout = timeout;
    }

    @ReadOperation
    public WebEndpointResponse<Resource> heapDump(@Nullable Boolean live) {
        block7: {
            if (!this.lock.tryLock(this.timeout, TimeUnit.MILLISECONDS)) break block7;
            try {
                WebEndpointResponse<Resource> webEndpointResponse = new WebEndpointResponse<Resource>(this.dumpHeap(live));
                this.lock.unlock();
                return webEndpointResponse;
            }
            catch (Throwable throwable) {
                try {
                    this.lock.unlock();
                    throw throwable;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException ex) {
                    return new WebEndpointResponse<Resource>(500);
                }
                catch (HeapDumperUnavailableException ex) {
                    return new WebEndpointResponse<Resource>(503);
                }
            }
        }
        return new WebEndpointResponse<Resource>(429);
    }

    private Resource dumpHeap(Boolean live) throws IOException, InterruptedException {
        if (this.heapDumper == null) {
            this.heapDumper = this.createHeapDumper();
        }
        File file = this.heapDumper.dumpHeap(live);
        return new TemporaryFileSystemResource(file);
    }

    protected HeapDumper createHeapDumper() throws HeapDumperUnavailableException {
        if (this.isRunningOnOpenJ9()) {
            return new OpenJ9DiagnosticsMXBeanHeapDumper();
        }
        return new HotSpotDiagnosticMXBeanHeapDumper();
    }

    private boolean isRunningOnOpenJ9() {
        String vmName = System.getProperty("java.vm.name");
        if (StringUtils.hasLength((String)vmName) && vmName.toLowerCase(Locale.ROOT).contains("openj9")) {
            return true;
        }
        String vmVendor = System.getProperty("java.vm.vendor");
        return StringUtils.hasLength((String)vmVendor) && vmVendor.toLowerCase(Locale.ROOT).contains("openj9");
    }

    protected static class HeapDumperUnavailableException
    extends RuntimeException {
        public HeapDumperUnavailableException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @FunctionalInterface
    protected static interface HeapDumper {
        public File dumpHeap(Boolean var1) throws IOException, InterruptedException;
    }

    private static final class TemporaryFileSystemResource
    extends FileSystemResource {
        private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

        private TemporaryFileSystemResource(File file) {
            super(file);
        }

        public ReadableByteChannel readableChannel() throws IOException {
            final ReadableByteChannel readableChannel = super.readableChannel();
            return new ReadableByteChannel(){

                @Override
                public boolean isOpen() {
                    return readableChannel.isOpen();
                }

                @Override
                public void close() throws IOException {
                    this.closeThenDeleteFile(readableChannel);
                }

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    return readableChannel.read(dst);
                }
            };
        }

        public InputStream getInputStream() throws IOException {
            return new FilterInputStream(super.getInputStream()){

                @Override
                public void close() throws IOException {
                    this.closeThenDeleteFile(this.in);
                }
            };
        }

        private void closeThenDeleteFile(Closeable closeable) throws IOException {
            try {
                closeable.close();
            }
            finally {
                this.deleteFile();
            }
        }

        private void deleteFile() {
            try {
                Files.delete(this.getFile().toPath());
            }
            catch (IOException ex) {
                this.logger.warn((Object)("Failed to delete temporary heap dump file '" + String.valueOf(this.getFile()) + "'"), (Throwable)ex);
            }
        }

        public boolean isFile() {
            return false;
        }
    }

    private static final class OpenJ9DiagnosticsMXBeanHeapDumper
    implements HeapDumper {
        private final Object diagnosticMXBean;
        private final Method dumpHeapMethod;

        private OpenJ9DiagnosticsMXBeanHeapDumper() {
            try {
                Class mxBeanClass = ClassUtils.resolveClassName((String)"openj9.lang.management.OpenJ9DiagnosticsMXBean", null);
                this.diagnosticMXBean = ManagementFactory.getPlatformMXBean(mxBeanClass);
                this.dumpHeapMethod = ReflectionUtils.findMethod((Class)mxBeanClass, (String)"triggerDumpToFile", (Class[])new Class[]{String.class, String.class});
            }
            catch (Throwable ex) {
                throw new HeapDumperUnavailableException("Unable to locate OpenJ9DiagnosticsMXBean", ex);
            }
        }

        @Override
        public File dumpHeap(Boolean live) throws IOException, InterruptedException {
            Assert.isNull((Object)live, (String)"OpenJ9DiagnosticsMXBean does not support live parameter when dumping the heap");
            return new File((String)ReflectionUtils.invokeMethod((Method)this.dumpHeapMethod, (Object)this.diagnosticMXBean, (Object[])new Object[]{"heap", null}));
        }
    }

    protected static class HotSpotDiagnosticMXBeanHeapDumper
    implements HeapDumper {
        private final Object diagnosticMXBean;
        private final Method dumpHeapMethod;

        protected HotSpotDiagnosticMXBeanHeapDumper() {
            try {
                Class diagnosticMXBeanClass = ClassUtils.resolveClassName((String)"com.sun.management.HotSpotDiagnosticMXBean", null);
                this.diagnosticMXBean = ManagementFactory.getPlatformMXBean(diagnosticMXBeanClass);
                this.dumpHeapMethod = ReflectionUtils.findMethod((Class)diagnosticMXBeanClass, (String)"dumpHeap", (Class[])new Class[]{String.class, Boolean.TYPE});
            }
            catch (Throwable ex) {
                throw new HeapDumperUnavailableException("Unable to locate HotSpotDiagnosticMXBean", ex);
            }
        }

        @Override
        public File dumpHeap(Boolean live) throws IOException {
            File file = this.createTempFile();
            ReflectionUtils.invokeMethod((Method)this.dumpHeapMethod, (Object)this.diagnosticMXBean, (Object[])new Object[]{file.getAbsolutePath(), live != null ? live : true});
            return file;
        }

        private File createTempFile() throws IOException {
            String date = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm").format(LocalDateTime.now());
            File file = File.createTempFile("heap-" + date, ".hprof");
            file.delete();
            return file;
        }
    }
}

