/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.couchbase;

import com.couchbase.client.core.message.internal.DiagnosticsReport;
import com.couchbase.client.java.Cluster;
import org.springframework.boot.actuate.couchbase.CouchbaseHealth;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import reactor.core.publisher.Mono;

public class CouchbaseReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private final Cluster cluster;

    public CouchbaseReactiveHealthIndicator(Cluster cluster) {
        this.cluster = cluster;
    }

    @Override
    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        DiagnosticsReport diagnostics = this.cluster.diagnostics();
        new CouchbaseHealth(diagnostics).applyTo(builder);
        return Mono.just((Object)builder.build());
    }
}

