/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.actuate.endpoint.Sanitizer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.env.StandardEnvironment;

@ConfigurationProperties(prefix="endpoints.env")
public class EnvironmentEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    private final Sanitizer sanitizer = new Sanitizer();

    public EnvironmentEndpoint() {
        super("env");
    }

    public void setKeysToSanitize(String ... keysToSanitize) {
        this.sanitizer.setKeysToSanitize(keysToSanitize);
    }

    @Override
    public Map<String, Object> invoke() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("profiles", this.getEnvironment().getActiveProfiles());
        PropertyResolver resolver = this.getResolver();
        for (Map.Entry<String, PropertySource<?>> entry : this.getPropertySourcesAsMap().entrySet()) {
            PropertySource<?> source = entry.getValue();
            String sourceName = entry.getKey();
            if (!(source instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            Map<String, Object> properties = new LinkedHashMap<String, Object>();
            for (String name : enumerable.getPropertyNames()) {
                Object property = source.getProperty(name);
                Object resolved = property instanceof String ? resolver.resolvePlaceholders((String)property) : property;
                properties.put(name, this.sanitize(name, resolved));
            }
            if ((properties = this.postProcessSourceProperties(sourceName, properties)) == null) continue;
            result.put(sourceName, properties);
        }
        return result;
    }

    public PropertyResolver getResolver() {
        PlaceholderSanitizingPropertyResolver resolver = new PlaceholderSanitizingPropertyResolver((PropertySources)this.getPropertySources(), this.sanitizer);
        resolver.setIgnoreUnresolvableNestedPlaceholders(true);
        return resolver;
    }

    private Map<String, PropertySource<?>> getPropertySourcesAsMap() {
        LinkedHashMap map = new LinkedHashMap();
        for (PropertySource source : this.getPropertySources()) {
            this.extract("", map, source);
        }
        return map;
    }

    private MutablePropertySources getPropertySources() {
        Environment environment = this.getEnvironment();
        MutablePropertySources sources = environment != null && environment instanceof ConfigurableEnvironment ? ((ConfigurableEnvironment)environment).getPropertySources() : new StandardEnvironment().getPropertySources();
        return sources;
    }

    private void extract(String root, Map<String, PropertySource<?>> map, PropertySource<?> source) {
        if (source instanceof CompositePropertySource) {
            for (PropertySource nest : ((CompositePropertySource)source).getPropertySources()) {
                this.extract(source.getName() + ":", map, nest);
            }
        } else {
            map.put(root + source.getName(), source);
        }
    }

    public Object sanitize(String name, Object object) {
        return this.sanitizer.sanitize(name, object);
    }

    protected Map<String, Object> postProcessSourceProperties(String sourceName, Map<String, Object> properties) {
        return properties;
    }

    private class PlaceholderSanitizingPropertyResolver
    extends PropertySourcesPropertyResolver {
        private final Sanitizer sanitizer;

        PlaceholderSanitizingPropertyResolver(PropertySources propertySources, Sanitizer sanitizer) {
            super(propertySources);
            this.sanitizer = sanitizer;
        }

        protected String getPropertyAsRawString(String key) {
            String value = super.getPropertyAsRawString(key);
            return (String)this.sanitizer.sanitize(key, value);
        }
    }
}

