/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.actuate.info.MapInfoContributor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="endpoints.info")
public class InfoEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    private final List<InfoContributor> infoContributors;

    public InfoEndpoint(List<InfoContributor> infoContributors) {
        super("info", false);
        Assert.notNull(infoContributors, (String)"Info contributors must not be null");
        this.infoContributors = infoContributors;
    }

    @Deprecated
    public InfoEndpoint(Map<String, Object> info, InfoContributor ... infoContributors) {
        this(InfoEndpoint.createContributors(info, infoContributors));
    }

    private static List<InfoContributor> createContributors(Map<String, Object> info, InfoContributor[] infoContributors) {
        ArrayList<InfoContributor> result = new ArrayList<InfoContributor>(Arrays.asList(infoContributors));
        result.add(0, new MapInfoContributor(info));
        return result;
    }

    @Override
    public Map<String, Object> invoke() {
        Info.Builder builder = new Info.Builder();
        for (InfoContributor contributor : this.infoContributors) {
            contributor.contribute(builder);
        }
        builder.withDetails(this.getAdditionalInfo());
        Info build = builder.build();
        return build.getDetails();
    }

    @Deprecated
    protected Map<String, Object> getAdditionalInfo() {
        return Collections.emptyMap();
    }
}

