/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.LiveBeansView;

@ConfigurationProperties(prefix="endpoints.beans")
public class BeansEndpoint
extends AbstractEndpoint<List<Object>>
implements ApplicationContextAware {
    private final LiveBeansView liveBeansView = new LiveBeansView();
    private final JsonParser parser = JsonParserFactory.getJsonParser();

    public BeansEndpoint() {
        super("beans");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (context.getEnvironment().getProperty("spring.liveBeansView.mbeanDomain") == null) {
            this.liveBeansView.setApplicationContext(context);
        }
    }

    @Override
    public List<Object> invoke() {
        return this.parser.parseList(this.liveBeansView.getSnapshotAsJson());
    }
}

