/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.EndpointProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public abstract class AbstractEndpoint<T>
implements Endpoint<T>,
EnvironmentAware {
    private Environment environment;
    @NotNull
    @Pattern(regexp="\\w+", message="ID must only contains letters, numbers and '_'")
    private String id;
    private final boolean sensitiveDefault;
    private Boolean sensitive;
    private Boolean enabled;

    public AbstractEndpoint(String id) {
        this(id, true);
    }

    public AbstractEndpoint(String id, boolean sensitive) {
        this.id = id;
        this.sensitiveDefault = sensitive;
    }

    public AbstractEndpoint(String id, boolean sensitive, boolean enabled) {
        this.id = id;
        this.sensitiveDefault = sensitive;
        this.enabled = enabled;
    }

    protected final Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isEnabled() {
        return EndpointProperties.isEnabled(this.environment, this.enabled);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isSensitive() {
        return EndpointProperties.isSensitive(this.environment, this.sensitive, this.sensitiveDefault);
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }
}

