/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.EndpointProperties;
import org.springframework.boot.actuate.endpoint.mvc.ManagementServletContext;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@ConfigurationProperties(value="endpoints.docs")
public class DocsMvcEndpoint
extends WebMvcConfigurerAdapter
implements MvcEndpoint,
EnvironmentAware {
    private static final String DOCS_LOCATION = "classpath:/META-INF/resources/spring-boot-actuator/docs/";
    private Environment environment;
    private String path = "/docs";
    private boolean enabled = true;
    private Boolean sensitive;
    private final ManagementServletContext managementServletContext;
    private Curies curies = new Curies();

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Curies getCuries() {
        return this.curies;
    }

    public DocsMvcEndpoint(ManagementServletContext managementServletContext) {
        this.managementServletContext = managementServletContext;
    }

    @RequestMapping(value={"/"}, produces={"text/html"})
    public String browse() {
        return "forward:" + this.managementServletContext.getContextPath() + this.path + "/index.html";
    }

    @RequestMapping(value={""}, produces={"text/html"})
    public String redirect() {
        return "redirect:" + this.managementServletContext.getContextPath() + this.path + "/";
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{this.managementServletContext.getContextPath() + this.path + "/**"}).addResourceLocations(new String[]{DOCS_LOCATION});
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isSensitive() {
        return EndpointProperties.isSensitive(this.environment, this.sensitive, false);
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }

    public Class<? extends Endpoint<?>> getEndpointType() {
        return null;
    }

    public static class Curies {
        private boolean enabled = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

