/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

public class SystemPublicMetrics
implements PublicMetrics,
Ordered {
    private long timestamp = System.currentTimeMillis();

    public int getOrder() {
        return -2147483638;
    }

    @Override
    public Collection<Metric<?>> metrics() {
        LinkedHashSet result = new LinkedHashSet();
        this.addBasicMetrics(result);
        this.addManagementMetrics(result);
        return result;
    }

    protected void addBasicMetrics(Collection<Metric<?>> result) {
        Runtime runtime = Runtime.getRuntime();
        result.add(this.newMemoryMetric("mem", runtime.totalMemory() + this.getTotalNonHeapMemoryIfPossible()));
        result.add(this.newMemoryMetric("mem.free", runtime.freeMemory()));
        result.add(new Metric<Integer>("processors", runtime.availableProcessors()));
        result.add(new Metric<Long>("instance.uptime", System.currentTimeMillis() - this.timestamp));
    }

    private long getTotalNonHeapMemoryIfPossible() {
        try {
            return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed();
        }
        catch (Throwable ex) {
            return 0L;
        }
    }

    private void addManagementMetrics(Collection<Metric<?>> result) {
        try {
            result.add(new Metric<Long>("uptime", ManagementFactory.getRuntimeMXBean().getUptime()));
            result.add(new Metric<Double>("systemload.average", ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage()));
            this.addHeapMetrics(result);
            this.addNonHeapMetrics(result);
            this.addThreadMetrics(result);
            this.addClassLoadingMetrics(result);
            this.addGarbageCollectionMetrics(result);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    protected void addHeapMetrics(Collection<Metric<?>> result) {
        MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        result.add(this.newMemoryMetric("heap.committed", memoryUsage.getCommitted()));
        result.add(this.newMemoryMetric("heap.init", memoryUsage.getInit()));
        result.add(this.newMemoryMetric("heap.used", memoryUsage.getUsed()));
        result.add(this.newMemoryMetric("heap", memoryUsage.getMax()));
    }

    private void addNonHeapMetrics(Collection<Metric<?>> result) {
        MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        result.add(this.newMemoryMetric("nonheap.committed", memoryUsage.getCommitted()));
        result.add(this.newMemoryMetric("nonheap.init", memoryUsage.getInit()));
        result.add(this.newMemoryMetric("nonheap.used", memoryUsage.getUsed()));
        result.add(this.newMemoryMetric("nonheap", memoryUsage.getMax()));
    }

    private Metric<Long> newMemoryMetric(String name, long bytes) {
        return new Metric<Long>(name, bytes / 1024L);
    }

    protected void addThreadMetrics(Collection<Metric<?>> result) {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        result.add(new Metric<Long>("threads.peak", Long.valueOf(threadMxBean.getPeakThreadCount())));
        result.add(new Metric<Long>("threads.daemon", Long.valueOf(threadMxBean.getDaemonThreadCount())));
        result.add(new Metric<Long>("threads.totalStarted", threadMxBean.getTotalStartedThreadCount()));
        result.add(new Metric<Long>("threads", Long.valueOf(threadMxBean.getThreadCount())));
    }

    protected void addClassLoadingMetrics(Collection<Metric<?>> result) {
        ClassLoadingMXBean classLoadingMxBean = ManagementFactory.getClassLoadingMXBean();
        result.add(new Metric<Long>("classes", Long.valueOf(classLoadingMxBean.getLoadedClassCount())));
        result.add(new Metric<Long>("classes.loaded", classLoadingMxBean.getTotalLoadedClassCount()));
        result.add(new Metric<Long>("classes.unloaded", classLoadingMxBean.getUnloadedClassCount()));
    }

    protected void addGarbageCollectionMetrics(Collection<Metric<?>> result) {
        List<GarbageCollectorMXBean> garbageCollectorMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean garbageCollectorMXBean : garbageCollectorMxBeans) {
            String name = this.beautifyGcName(garbageCollectorMXBean.getName());
            result.add(new Metric<Long>("gc." + name + ".count", garbageCollectorMXBean.getCollectionCount()));
            result.add(new Metric<Long>("gc." + name + ".time", garbageCollectorMXBean.getCollectionTime()));
        }
    }

    private String beautifyGcName(String name) {
        return StringUtils.replace((String)name, (String)" ", (String)"_").toLowerCase();
    }
}

