/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.rich;

import org.springframework.util.Assert;

public final class RichGauge {
    private final String name;
    private double value;
    private double average;
    private double max;
    private double min;
    private long count;
    private double alpha;

    public RichGauge(String name) {
        this(name, 0.0);
        this.count = 0L;
    }

    public RichGauge(String name, double value) {
        Assert.notNull((Object)name, (String)"The gauge name cannot be null or empty");
        this.name = name;
        this.average = this.value = value;
        this.min = this.value;
        this.max = this.value;
        this.alpha = -1.0;
        this.count = 1L;
    }

    public RichGauge(String name, double value, double alpha, double mean, double max, double min, long count) {
        this.name = name;
        this.value = value;
        this.alpha = alpha;
        this.average = mean;
        this.max = max;
        this.min = min;
        this.count = count;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public double getAverage() {
        return this.average;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public long getCount() {
        return this.count;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public RichGauge setAlpha(double alpha) {
        Assert.isTrue((alpha == -1.0 || alpha > 0.0 && alpha < 1.0 ? 1 : 0) != 0, (String)"Smoothing constant must be between 0 and 1, or -1 to use arithmetic mean");
        this.alpha = alpha;
        return this;
    }

    RichGauge set(double value) {
        if (this.count == 0L) {
            this.max = value;
            this.min = value;
        } else if (value > this.max) {
            this.max = value;
        } else if (value < this.min) {
            this.min = value;
        }
        if (this.alpha > 0.0 && this.count > 0L) {
            this.average = this.alpha * this.value + (1.0 - this.alpha) * this.average;
        } else {
            double sum = this.average * (double)this.count;
            this.average = (sum += value) / (double)(this.count + 1L);
        }
        ++this.count;
        this.value = value;
        return this;
    }

    RichGauge reset() {
        this.value = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        this.average = 0.0;
        this.count = 0L;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichGauge richGauge = (RichGauge)o;
        return this.name.equals(richGauge.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Gauge [name = " + this.name + ", value = " + this.value + ", alpha = " + this.alpha + ", average = " + this.average + ", max = " + this.max + ", min = " + this.min + ", count = " + this.count + "]";
    }
}

