/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.info;

import org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.actuate.autoconfigure.info.InfoContributorFallback;
import org.springframework.boot.actuate.autoconfigure.info.InfoContributorProperties;
import org.springframework.boot.actuate.info.BuildInfoContributor;
import org.springframework.boot.actuate.info.EnvironmentInfoContributor;
import org.springframework.boot.actuate.info.GitInfoContributor;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.actuate.info.JavaInfoContributor;
import org.springframework.boot.actuate.info.OsInfoContributor;
import org.springframework.boot.actuate.info.ProcessInfoContributor;
import org.springframework.boot.actuate.info.SslInfoContributor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.info.ProjectInfoAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.boot.info.SslInfo;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;

@AutoConfiguration(after={ProjectInfoAutoConfiguration.class})
@EnableConfigurationProperties(value={InfoContributorProperties.class})
public final class InfoContributorAutoConfiguration {
    public static final int DEFAULT_ORDER = -2147483638;

    @Bean
    @ConditionalOnEnabledInfoContributor(value="env", fallback=InfoContributorFallback.DISABLE)
    @Order(value=-2147483638)
    EnvironmentInfoContributor envInfoContributor(ConfigurableEnvironment environment) {
        return new EnvironmentInfoContributor(environment);
    }

    @Bean
    @ConditionalOnEnabledInfoContributor(value="git")
    @ConditionalOnSingleCandidate(value=GitProperties.class)
    @ConditionalOnMissingBean
    @Order(value=-2147483638)
    GitInfoContributor gitInfoContributor(GitProperties gitProperties, InfoContributorProperties infoContributorProperties) {
        return new GitInfoContributor(gitProperties, infoContributorProperties.getGit().getMode());
    }

    @Bean
    @ConditionalOnEnabledInfoContributor(value="build")
    @ConditionalOnSingleCandidate(value=BuildProperties.class)
    @Order(value=-2147483638)
    InfoContributor buildInfoContributor(BuildProperties buildProperties) {
        return new BuildInfoContributor(buildProperties);
    }

    @Bean
    @ConditionalOnEnabledInfoContributor(value="java", fallback=InfoContributorFallback.DISABLE)
    @Order(value=-2147483638)
    JavaInfoContributor javaInfoContributor() {
        return new JavaInfoContributor();
    }

    @Bean
    @ConditionalOnEnabledInfoContributor(value="os", fallback=InfoContributorFallback.DISABLE)
    @Order(value=-2147483638)
    OsInfoContributor osInfoContributor() {
        return new OsInfoContributor();
    }

    @Bean
    @ConditionalOnEnabledInfoContributor(value="process", fallback=InfoContributorFallback.DISABLE)
    @Order(value=-2147483638)
    ProcessInfoContributor processInfoContributor() {
        return new ProcessInfoContributor();
    }

    @Bean
    @ConditionalOnEnabledInfoContributor(value="ssl", fallback=InfoContributorFallback.DISABLE)
    @Order(value=-2147483638)
    SslInfoContributor sslInfoContributor(SslInfo sslInfo) {
        return new SslInfoContributor(sslInfo);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledInfoContributor(value="ssl", fallback=InfoContributorFallback.DISABLE)
    SslInfo sslInfo(SslBundles sslBundles) {
        return new SslInfo(sslBundles);
    }
}

