/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.availability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.autoconfigure.availability.AvailabilityProbesHealthEndpointGroup;
import org.springframework.boot.actuate.autoconfigure.availability.DelegatingAvailabilityProbesHealthEndpointGroup;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.web.AdditionalPathsMapper;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.health.AdditionalHealthEndpointPath;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroup;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.util.Assert;

class AvailabilityProbesHealthEndpointGroups
implements HealthEndpointGroups,
AdditionalPathsMapper {
    private final HealthEndpointGroups groups;
    private final Map<String, HealthEndpointGroup> probeGroups;
    private final Set<String> names;
    private static final String LIVENESS = "liveness";
    private static final String READINESS = "readiness";

    AvailabilityProbesHealthEndpointGroups(HealthEndpointGroups groups, boolean addAdditionalPaths) {
        Assert.notNull((Object)groups, (String)"'groups' must not be null");
        this.groups = groups;
        this.probeGroups = this.createProbeGroups(addAdditionalPaths);
        LinkedHashSet<String> names = new LinkedHashSet<String>(groups.getNames());
        names.addAll(this.probeGroups.keySet());
        this.names = Collections.unmodifiableSet(names);
    }

    private Map<String, HealthEndpointGroup> createProbeGroups(boolean addAdditionalPaths) {
        LinkedHashMap<String, HealthEndpointGroup> probeGroups = new LinkedHashMap<String, HealthEndpointGroup>();
        probeGroups.put(LIVENESS, this.getOrCreateProbeGroup(addAdditionalPaths, LIVENESS, "/livez", "livenessState"));
        probeGroups.put(READINESS, this.getOrCreateProbeGroup(addAdditionalPaths, READINESS, "/readyz", "readinessState"));
        return Collections.unmodifiableMap(probeGroups);
    }

    private HealthEndpointGroup getOrCreateProbeGroup(boolean addAdditionalPath, String name, String path, String members) {
        HealthEndpointGroup group = this.groups.get(name);
        if (group != null) {
            return this.determineAdditionalPathForExistingGroup(addAdditionalPath, path, group);
        }
        AdditionalHealthEndpointPath additionalPath = !addAdditionalPath ? null : AdditionalHealthEndpointPath.of((WebServerNamespace)WebServerNamespace.SERVER, (String)path);
        return new AvailabilityProbesHealthEndpointGroup(additionalPath, members);
    }

    private HealthEndpointGroup determineAdditionalPathForExistingGroup(boolean addAdditionalPath, String path, HealthEndpointGroup group) {
        if (addAdditionalPath && group.getAdditionalPath() == null) {
            AdditionalHealthEndpointPath additionalPath = AdditionalHealthEndpointPath.of((WebServerNamespace)WebServerNamespace.SERVER, (String)path);
            return new DelegatingAvailabilityProbesHealthEndpointGroup(group, additionalPath);
        }
        return group;
    }

    public HealthEndpointGroup getPrimary() {
        return this.groups.getPrimary();
    }

    public Set<String> getNames() {
        return this.names;
    }

    public @Nullable HealthEndpointGroup get(String name) {
        HealthEndpointGroup group = this.groups.get(name);
        if (group == null || this.isProbeGroup(name)) {
            group = this.probeGroups.get(name);
        }
        return group;
    }

    private boolean isProbeGroup(String name) {
        return name.equals(LIVENESS) || name.equals(READINESS);
    }

    public @Nullable List<String> getAdditionalPaths(EndpointId endpointId, WebServerNamespace webServerNamespace) {
        if (!HealthEndpoint.ID.equals((Object)endpointId)) {
            return null;
        }
        ArrayList<String> additionalPaths = new ArrayList<String>();
        HealthEndpointGroups healthEndpointGroups = this.groups;
        if (healthEndpointGroups instanceof AdditionalPathsMapper) {
            AdditionalPathsMapper additionalPathsMapper = (AdditionalPathsMapper)healthEndpointGroups;
            additionalPaths.addAll(additionalPathsMapper.getAdditionalPaths(endpointId, webServerNamespace));
        }
        additionalPaths.addAll(this.probeGroups.values().stream().map(HealthEndpointGroup::getAdditionalPath).filter(Objects::nonNull).filter(additionalPath -> additionalPath.hasNamespace(webServerNamespace)).map(AdditionalHealthEndpointPath::getValue).toList());
        return additionalPaths;
    }
}

