/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.util.List;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.boot.LazyInitializationBeanFactoryPostProcessor;
import org.springframework.boot.actuate.autoconfigure.web.server.EnableChildManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementContextFactory;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.web.server.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.server.context.WebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.context.aot.ApplicationContextAotGenerator;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.javapoet.ClassName;
import org.springframework.util.Assert;

class ChildManagementContextInitializer
implements BeanRegistrationAotProcessor,
SmartLifecycle {
    private final ManagementContextFactory managementContextFactory;
    private final AbstractApplicationContext parentContext;
    private final ApplicationContextInitializer<ConfigurableApplicationContext> applicationContextInitializer;
    private volatile ConfigurableApplicationContext managementContext;

    ChildManagementContextInitializer(ManagementContextFactory managementContextFactory, AbstractApplicationContext parentContext) {
        this(managementContextFactory, parentContext, null);
    }

    private ChildManagementContextInitializer(ManagementContextFactory managementContextFactory, AbstractApplicationContext parentContext, ApplicationContextInitializer<? extends ConfigurableApplicationContext> applicationContextInitializer) {
        this.managementContextFactory = managementContextFactory;
        this.parentContext = parentContext;
        this.applicationContextInitializer = applicationContextInitializer;
    }

    public void start() {
        if (!(this.parentContext instanceof WebServerApplicationContext)) {
            return;
        }
        if (this.managementContext == null) {
            ConfigurableApplicationContext managementContext = this.createManagementContext();
            this.registerBeans(managementContext);
            managementContext.refresh();
            this.managementContext = managementContext;
        } else {
            this.managementContext.start();
        }
    }

    public void stop() {
        if (this.managementContext != null) {
            if (this.parentContext.isClosed()) {
                this.managementContext.close();
            } else {
                this.managementContext.stop();
            }
        }
    }

    public boolean isRunning() {
        return this.managementContext != null && this.managementContext.isRunning();
    }

    public int getPhase() {
        return 0x7FFFF9FF;
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)this.parentContext);
        ConfigurableListableBeanFactory parentBeanFactory = this.parentContext.getBeanFactory();
        if (registeredBean.getBeanClass().equals(this.getClass()) && registeredBean.getBeanFactory().equals((Object)parentBeanFactory)) {
            ConfigurableApplicationContext managementContext = this.createManagementContext();
            this.registerBeans(managementContext);
            return new AotContribution(managementContext);
        }
        return null;
    }

    public boolean isBeanExcludedFromAotProcessing() {
        return false;
    }

    private void registerBeans(ConfigurableApplicationContext managementContext) {
        if (this.applicationContextInitializer != null) {
            this.applicationContextInitializer.initialize(managementContext);
            return;
        }
        Assert.isInstanceOf(AnnotationConfigRegistry.class, (Object)managementContext);
        AnnotationConfigRegistry registry = (AnnotationConfigRegistry)managementContext;
        this.managementContextFactory.registerWebServerFactoryBeans((ApplicationContext)this.parentContext, managementContext, registry);
        registry.register(new Class[]{EnableChildManagementContextConfiguration.class, PropertyPlaceholderAutoConfiguration.class});
        if (this.isLazyInitialization()) {
            managementContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new LazyInitializationBeanFactoryPostProcessor());
        }
    }

    protected final ConfigurableApplicationContext createManagementContext() {
        ConfigurableApplicationContext managementContext = this.managementContextFactory.createManagementContext((ApplicationContext)this.parentContext);
        managementContext.setId(this.parentContext.getId() + ":management");
        if (managementContext instanceof ConfigurableWebServerApplicationContext) {
            ConfigurableWebServerApplicationContext webServerApplicationContext = (ConfigurableWebServerApplicationContext)managementContext;
            webServerApplicationContext.setServerNamespace("management");
        }
        if (managementContext instanceof DefaultResourceLoader) {
            DefaultResourceLoader resourceLoader = (DefaultResourceLoader)managementContext;
            resourceLoader.setClassLoader(this.parentContext.getClassLoader());
        }
        CloseManagementContextListener.addIfPossible((ApplicationContext)this.parentContext, managementContext);
        return managementContext;
    }

    private boolean isLazyInitialization() {
        List postProcessors = this.parentContext.getBeanFactoryPostProcessors();
        return postProcessors.stream().anyMatch(LazyInitializationBeanFactoryPostProcessor.class::isInstance);
    }

    ChildManagementContextInitializer withApplicationContextInitializer(ApplicationContextInitializer<? extends ConfigurableApplicationContext> applicationContextInitializer) {
        return new ChildManagementContextInitializer(this.managementContextFactory, this.parentContext, applicationContextInitializer);
    }

    private static class AotContribution
    implements BeanRegistrationAotContribution {
        private final GenericApplicationContext managementContext;

        AotContribution(ConfigurableApplicationContext managementContext) {
            Assert.isInstanceOf(GenericApplicationContext.class, (Object)managementContext);
            this.managementContext = (GenericApplicationContext)managementContext;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            GenerationContext managementGenerationContext = generationContext.withName("Management");
            ClassName generatedInitializerClassName = new ApplicationContextAotGenerator().processAheadOfTime(this.managementContext, managementGenerationContext);
            GeneratedMethod postProcessorMethod = beanRegistrationCode.getMethods().add("addManagementInitializer", method -> method.addJavadoc("Use AOT management context initialization", new Object[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter(RegisteredBean.class, "registeredBean", new Modifier[0]).addParameter(ChildManagementContextInitializer.class, "instance", new Modifier[0]).returns(ChildManagementContextInitializer.class).addStatement("return instance.withApplicationContextInitializer(new $L())", new Object[]{generatedInitializerClassName}));
            beanRegistrationCode.addInstancePostProcessor(postProcessorMethod.toMethodReference());
        }
    }

    private static class CloseManagementContextListener
    implements ApplicationListener<ApplicationEvent> {
        private final ApplicationContext parentContext;
        private final ConfigurableApplicationContext childContext;

        CloseManagementContextListener(ApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            this.parentContext = parentContext;
            this.childContext = childContext;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof ApplicationFailedEvent) {
                ApplicationFailedEvent applicationFailedEvent = (ApplicationFailedEvent)event;
                this.onApplicationFailedEvent(applicationFailedEvent);
            }
        }

        private void onApplicationFailedEvent(ApplicationFailedEvent event) {
            this.propagateCloseIfNecessary((ApplicationContext)event.getApplicationContext());
        }

        private void propagateCloseIfNecessary(ApplicationContext applicationContext) {
            if (applicationContext == this.parentContext) {
                this.childContext.close();
            }
        }

        static void addIfPossible(ApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            if (parentContext instanceof ConfigurableApplicationContext) {
                ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)parentContext;
                CloseManagementContextListener.add(configurableApplicationContext, childContext);
            }
        }

        private static void add(ConfigurableApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            parentContext.addApplicationListener((ApplicationListener)new CloseManagementContextListener((ApplicationContext)parentContext, childContext));
        }
    }
}

