/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.logging.otlp;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import java.util.Locale;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.logging.ConditionalOnEnabledLoggingExport;
import org.springframework.boot.actuate.autoconfigure.logging.otlp.OtlpLoggingConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.logging.otlp.OtlpLoggingProperties;
import org.springframework.boot.actuate.autoconfigure.logging.otlp.Transport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

final class OtlpLoggingConfigurations {
    OtlpLoggingConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={OtlpGrpcLogRecordExporter.class, OtlpHttpLogRecordExporter.class})
    @ConditionalOnBean(value={OtlpLoggingConnectionDetails.class})
    @ConditionalOnEnabledLoggingExport(value="otlp")
    static class Exporters {
        Exporters() {
        }

        @Bean
        @ConditionalOnProperty(name={"management.otlp.logging.transport"}, havingValue="http", matchIfMissing=true)
        OtlpHttpLogRecordExporter otlpHttpLogRecordExporter(OtlpLoggingProperties properties, OtlpLoggingConnectionDetails connectionDetails, ObjectProvider<MeterProvider> meterProvider) {
            OtlpHttpLogRecordExporterBuilder builder = OtlpHttpLogRecordExporter.builder().setEndpoint(connectionDetails.getUrl(Transport.HTTP)).setTimeout(properties.getTimeout()).setConnectTimeout(properties.getConnectTimeout()).setCompression(properties.getCompression().name().toLowerCase(Locale.US));
            properties.getHeaders().forEach((arg_0, arg_1) -> ((OtlpHttpLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1));
            meterProvider.ifAvailable(arg_0 -> ((OtlpHttpLogRecordExporterBuilder)builder).setMeterProvider(arg_0));
            return builder.build();
        }

        @Bean
        @ConditionalOnProperty(name={"management.otlp.logging.transport"}, havingValue="grpc")
        OtlpGrpcLogRecordExporter otlpGrpcLogRecordExporter(OtlpLoggingProperties properties, OtlpLoggingConnectionDetails connectionDetails, ObjectProvider<MeterProvider> meterProvider) {
            OtlpGrpcLogRecordExporterBuilder builder = OtlpGrpcLogRecordExporter.builder().setEndpoint(connectionDetails.getUrl(Transport.GRPC)).setTimeout(properties.getTimeout()).setConnectTimeout(properties.getConnectTimeout()).setCompression(properties.getCompression().name().toLowerCase(Locale.US));
            properties.getHeaders().forEach((arg_0, arg_1) -> ((OtlpGrpcLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1));
            meterProvider.ifAvailable(arg_0 -> ((OtlpGrpcLogRecordExporterBuilder)builder).setMeterProvider(arg_0));
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ConnectionDetails {
        ConnectionDetails() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"management.otlp.logging.endpoint"})
        OtlpLoggingConnectionDetails otlpLoggingConnectionDetails(OtlpLoggingProperties properties) {
            return new PropertiesOtlpLoggingConnectionDetails(properties);
        }

        static class PropertiesOtlpLoggingConnectionDetails
        implements OtlpLoggingConnectionDetails {
            private final OtlpLoggingProperties properties;

            PropertiesOtlpLoggingConnectionDetails(OtlpLoggingProperties properties) {
                this.properties = properties;
            }

            @Override
            public String getUrl(Transport transport) {
                Assert.state((transport == this.properties.getTransport() ? 1 : 0) != 0, (String)"Requested transport %s doesn't match configured transport %s".formatted(new Object[]{transport, this.properties.getTransport()}));
                return this.properties.getEndpoint();
            }
        }
    }
}

