/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.servlet;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

class CompositeHandlerExceptionResolver
implements HandlerExceptionResolver {
    @Autowired
    private ListableBeanFactory beanFactory;
    private List<HandlerExceptionResolver> resolvers;

    CompositeHandlerExceptionResolver() {
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ModelAndView resolved;
        if (this.resolvers == null) {
            this.resolvers = this.extractResolvers();
        }
        if ((resolved = (ModelAndView)this.resolvers.stream().map(resolver -> resolver.resolveException(request, response, handler, ex)).filter(Objects::nonNull).findFirst().orElse(null)) != null && resolved.isEmpty()) {
            request.setAttribute("javax.servlet.error.exception", (Object)ex);
        }
        return resolved;
    }

    private List<HandlerExceptionResolver> extractResolvers() {
        ArrayList<HandlerExceptionResolver> list = new ArrayList<HandlerExceptionResolver>(this.beanFactory.getBeansOfType(HandlerExceptionResolver.class).values());
        list.remove(this);
        AnnotationAwareOrderComparator.sort(list);
        if (list.isEmpty()) {
            list.add((HandlerExceptionResolver)new DefaultHandlerExceptionResolver());
        }
        return list;
    }
}

