/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicatorRegistry;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.util.Assert;

class HealthContributorRegistryHealthIndicatorRegistryAdapter
implements HealthIndicatorRegistry {
    private final HealthContributorRegistry contributorRegistry;

    HealthContributorRegistryHealthIndicatorRegistryAdapter(HealthContributorRegistry contributorRegistry) {
        Assert.notNull((Object)contributorRegistry, (String)"ContributorRegistry must not be null");
        this.contributorRegistry = contributorRegistry;
    }

    public void register(String name, HealthIndicator healthIndicator) {
        this.contributorRegistry.registerContributor(name, (Object)healthIndicator);
    }

    public HealthIndicator unregister(String name) {
        HealthContributor contributor = (HealthContributor)this.contributorRegistry.unregisterContributor(name);
        if (contributor instanceof HealthIndicator) {
            return (HealthIndicator)contributor;
        }
        return null;
    }

    public HealthIndicator get(String name) {
        HealthContributor contributor = (HealthContributor)this.contributorRegistry.getContributor(name);
        if (contributor instanceof HealthIndicator) {
            return (HealthIndicator)contributor;
        }
        return null;
    }

    public Map<String, HealthIndicator> getAll() {
        LinkedHashMap<String, HealthIndicator> all = new LinkedHashMap<String, HealthIndicator>();
        for (NamedContributor namedContributor : this.contributorRegistry) {
            if (!(namedContributor.getContributor() instanceof HealthIndicator)) continue;
            all.put(namedContributor.getName(), (HealthIndicator)namedContributor.getContributor());
        }
        return all;
    }
}

