/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCoordinates;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JarModeLibrary
extends Library {
    public static final JarModeLibrary LAYER_TOOLS = new JarModeLibrary("spring-boot-jarmode-layertools");

    JarModeLibrary(String artifactId) {
        this(JarModeLibrary.createCoordinates(artifactId));
    }

    public JarModeLibrary(LibraryCoordinates coordinates) {
        super(JarModeLibrary.getJarName(coordinates), null, LibraryScope.RUNTIME, coordinates, false, false, true);
    }

    private static LibraryCoordinates createCoordinates(String artifactId) {
        String version = JarModeLibrary.class.getPackage().getImplementationVersion();
        return LibraryCoordinates.of("org.springframework.boot", artifactId, version);
    }

    private static String getJarName(LibraryCoordinates coordinates) {
        String version = coordinates.getVersion();
        StringBuilder jarName = new StringBuilder(coordinates.getArtifactId());
        if (StringUtils.hasText(version)) {
            jarName.append('-');
            jarName.append(version);
        }
        jarName.append(".jar");
        return jarName.toString();
    }

    @Override
    public InputStream openStream() throws IOException {
        String path = "META-INF/jarmode/" + this.getCoordinates().getArtifactId() + ".jar";
        URL resource = this.getClass().getClassLoader().getResource(path);
        Assert.state(resource != null, () -> "Unable to find resource " + path);
        return resource.openStream();
    }

    @Override
    long getLastModified() {
        return 0L;
    }

    @Override
    public File getFile() {
        throw new UnsupportedOperationException("Unable to access jar mode library file");
    }
}

