/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.thin;

import hidden.org.apache.maven.model.Dependency;
import hidden.org.apache.maven.model.DependencyManagement;
import hidden.org.apache.maven.model.Exclusion;
import hidden.org.apache.maven.model.Model;
import hidden.org.apache.maven.model.building.DefaultModelProcessor;
import hidden.org.eclipse.aether.artifact.DefaultArtifact;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.loader.thin.DependencyResolver;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.util.StringUtils;

class ThinPropertiesModelProcessor
extends DefaultModelProcessor {
    static final String DEFAULT_EXTENSION = "jar";
    static final String EMPTY_CLASSIFIER = "";

    ThinPropertiesModelProcessor() {
    }

    @Override
    public Model read(File input, Map<String, ?> options) throws IOException {
        Model model = super.read(input, options);
        return this.process(model);
    }

    @Override
    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Model model = super.read(input, options);
        return this.process(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        try {
            Model model = super.read(new BufferedInputStream(input){

                @Override
                public void close() throws IOException {
                }
            }, options);
            Model model2 = this.process(model);
            return model2;
        }
        finally {
            input.close();
        }
    }

    private Model process(Model model) {
        Properties properties = DependencyResolver.getGlobals();
        return ThinPropertiesModelProcessor.process(model, properties);
    }

    static Model process(Model model, Properties properties) {
        if (properties != null) {
            HashSet<String> exclusions = new HashSet<String>();
            for (String name : properties.stringPropertyNames()) {
                String pom;
                boolean replaced;
                DefaultArtifact artifact;
                if (name.startsWith("boms.")) {
                    String bom = ThinPropertiesModelProcessor.replacePlaceholder(properties, properties.getProperty(name));
                    artifact = ThinPropertiesModelProcessor.artifact(bom);
                    if (model.getDependencyManagement() == null) {
                        model.setDependencyManagement(new DependencyManagement());
                    }
                    replaced = false;
                    for (Dependency dependency : model.getDependencyManagement().getDependencies()) {
                        if (!ObjectUtils.nullSafeEquals(artifact.getArtifactId(), dependency.getArtifactId()) || !ObjectUtils.nullSafeEquals(artifact.getGroupId(), dependency.getGroupId())) continue;
                        dependency.setVersion(artifact.getVersion());
                    }
                    if (ThinPropertiesModelProcessor.isParentBom(model, artifact)) {
                        model.getParent().setVersion(artifact.getVersion());
                        replaced = true;
                    }
                    if (replaced) continue;
                    model.getDependencyManagement().addDependency(ThinPropertiesModelProcessor.bom(artifact));
                    continue;
                }
                if (name.startsWith("dependencies.")) {
                    pom = ThinPropertiesModelProcessor.replacePlaceholder(properties, properties.getProperty(name));
                    artifact = ThinPropertiesModelProcessor.artifact(pom);
                    replaced = false;
                    for (Dependency dependency : model.getDependencies()) {
                        if (!ObjectUtils.nullSafeEquals(artifact.getArtifactId(), dependency.getArtifactId()) || !ObjectUtils.nullSafeEquals(artifact.getGroupId(), dependency.getGroupId()) || !ThinPropertiesModelProcessor.equalOrEmpty(artifact.getClassifier(), dependency.getClassifier())) continue;
                        if (StringUtils.hasText(artifact.getVersion())) {
                            dependency.setVersion(artifact.getVersion());
                        }
                        dependency.setScope("runtime");
                        replaced = true;
                    }
                    if (replaced) continue;
                    model.getDependencies().add(ThinPropertiesModelProcessor.dependency(artifact));
                    continue;
                }
                if (!name.startsWith("exclusions.")) continue;
                pom = ThinPropertiesModelProcessor.replacePlaceholder(properties, properties.getProperty(name));
                exclusions.add(pom);
            }
            for (String pom : exclusions) {
                Exclusion exclusion = ThinPropertiesModelProcessor.exclusion(pom);
                Dependency target = ThinPropertiesModelProcessor.dependency(ThinPropertiesModelProcessor.artifact(pom));
                Dependency excluded = null;
                for (Dependency dependency : model.getDependencies()) {
                    dependency.addExclusion(exclusion);
                    if (!ThinPropertiesModelProcessor.isSameArtifact(target, dependency)) continue;
                    excluded = dependency;
                }
                if (excluded == null) continue;
                model.getDependencies().remove(excluded);
            }
        }
        for (Dependency dependency : new ArrayList<Dependency>(model.getDependencies())) {
            if (!"test".equals(dependency.getScope()) && !"provided".equals(dependency.getScope())) continue;
            model.getDependencies().remove(dependency);
        }
        return model;
    }

    private static boolean equalOrEmpty(String first, String second) {
        return ObjectUtils.nullSafeEquals(first, second) || !StringUtils.hasText(first) && !StringUtils.hasText(second);
    }

    static boolean isSameArtifact(Dependency target, Dependency dependency) {
        boolean classifierMatch = target.getClassifier() == null && dependency.getClassifier() == null || target.getClassifier() != null && target.getClassifier().equals(dependency.getClassifier());
        return dependency.getGroupId().equals(target.getGroupId()) && dependency.getArtifactId().equals(target.getArtifactId()) && classifierMatch;
    }

    private static String replacePlaceholder(Properties properties, String value) {
        PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}");
        return helper.replacePlaceholders(value, properties);
    }

    private static Exclusion exclusion(String pom) {
        Exclusion exclusion = new Exclusion();
        DefaultArtifact artifact = ThinPropertiesModelProcessor.artifact(pom);
        exclusion.setGroupId(artifact.getGroupId());
        exclusion.setArtifactId(artifact.getArtifactId());
        return exclusion;
    }

    private static Dependency bom(DefaultArtifact artifact) {
        Dependency result = ThinPropertiesModelProcessor.dependency(artifact);
        result.setType("pom");
        result.setScope("import");
        return result;
    }

    private static boolean isParentBom(Model model, DefaultArtifact artifact) {
        if (model.getParent() == null) {
            return false;
        }
        if (ObjectUtils.nullSafeEquals(artifact.getArtifactId(), model.getParent().getArtifactId()) && ObjectUtils.nullSafeEquals(artifact.getGroupId(), model.getParent().getGroupId())) {
            return true;
        }
        return ObjectUtils.nullSafeEquals("spring-boot-starter-parent", model.getParent().getArtifactId()) && ObjectUtils.nullSafeEquals(artifact.getArtifactId(), "spring-boot-dependencies");
    }

    static Dependency dependency(DefaultArtifact artifact) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(StringUtils.hasLength(artifact.getVersion()) ? artifact.getVersion() : null);
        dependency.setClassifier(StringUtils.hasLength(artifact.getClassifier()) ? artifact.getClassifier() : null);
        dependency.setType(artifact.getExtension());
        return dependency;
    }

    static DefaultArtifact artifact(String coordinates) {
        Pattern p = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?(:([^: ]+))?");
        Matcher m = p.matcher(coordinates);
        Assert.isTrue(m.matches(), "Bad artifact coordinates " + coordinates + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]][:<version>]");
        String groupId = m.group(1);
        String artifactId = m.group(2);
        String version = null;
        String extension = DEFAULT_EXTENSION;
        String classifier = EMPTY_CLASSIFIER;
        if (StringUtils.hasLength(m.group(4))) {
            extension = m.group(4);
        }
        if (StringUtils.hasLength(m.group(8))) {
            version = m.group(8);
        }
        if (StringUtils.hasLength(m.group(6))) {
            classifier = m.group(6);
            if (version == null && ThinPropertiesModelProcessor.isVersion(classifier)) {
                version = classifier;
                classifier = EMPTY_CLASSIFIER;
            }
        } else if (version == null && ThinPropertiesModelProcessor.isVersion(extension)) {
            version = extension;
            extension = DEFAULT_EXTENSION;
        }
        return new DefaultArtifact(groupId, artifactId, classifier, extension, version);
    }

    private static boolean isVersion(String label) {
        return label.endsWith("-SNAPSHOT") || !label.matches("[a-zA-Z]+[0-9]*");
    }
}

