/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.thin;

import hidden.org.apache.maven.shared.utils.io.FileUtils;
import hidden.org.eclipse.aether.graph.Dependency;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.thin.DependencyResolver;
import org.springframework.boot.loader.thin.UrlArchive;
import org.springframework.core.io.AbstractFileResolvingResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class PathResolver {
    private static final Logger log = LoggerFactory.getLogger(PathResolver.class);
    private final DependencyResolver engine;
    private ResourceLoader resources = new DefaultResourceLoader();
    private String[] locations = new String[]{"classpath:/", "file:."};
    private String root;
    private String libs;
    private Properties overrides = new Properties();
    private boolean offline;
    private boolean force;
    private boolean preferLocalSnapshots = true;

    public PathResolver(DependencyResolver engine) {
        this.engine = engine;
    }

    public void setLocations(String ... locations) {
        this.locations = locations;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setLibs(String libs) {
        this.libs = libs;
    }

    public void setOverrides(Properties overrides) {
        this.overrides = overrides;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public List<Archive> resolve(Archive archive, String name, String ... profiles) {
        return this.resolve(null, archive, name, profiles);
    }

    public List<Archive> resolve(Archive parent, Archive archive, String name, String ... profiles) {
        log.info("Extracting dependencies from: {}, with profiles {}", (Object)archive, (Object)Arrays.asList(profiles));
        ArrayList<Archive> archives = new ArrayList<Archive>();
        if (parent != null) {
            archives.addAll(this.archives(this.extract(parent, archive, name, profiles)));
        } else {
            archives.addAll(this.archives(this.extract(archive, name, profiles)));
        }
        this.addRootArchive(archives, archive);
        return archives;
    }

    public Resource getPom(Archive archive) {
        AbstractFileResolvingResource pom;
        try {
            String base = archive.getUrl().toString();
            pom = new UrlResource(base + "pom.xml");
            if (!pom.exists()) {
                String path = "target/classes/";
                if (base.endsWith(path)) {
                    pom = new UrlResource(base.substring(0, base.length() - path.length()) + "pom.xml");
                }
                if (!pom.exists() && base.endsWith(path = "target/test-classes/")) {
                    pom = new UrlResource(base.substring(0, base.length() - path.length()) + "pom.xml");
                }
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot locate archive", e);
        }
        if (!pom.exists()) {
            String artifactId;
            try {
                artifactId = this.extractArtifactId(archive);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Cannot locate archive", e);
            }
            String pattern = "META-INF/maven/**" + (artifactId == null || artifactId.length() == 0 ? "" : "/" + artifactId) + "/pom.xml";
            Resource resource = this.findResource(archive, pattern);
            if (resource != null) {
                return resource;
            }
            pattern = "BOOT-INF/classes/META-INF/maven/**" + (artifactId == null || artifactId.length() == 0 ? "" : "/" + artifactId) + "/pom.xml";
            resource = this.findResource(archive, pattern);
            if (resource != null) {
                return resource;
            }
            pattern = "META-INF/maven/**/pom.xml";
            resource = this.findResource(archive, pattern);
            if (resource != null) {
                return resource;
            }
            pattern = "**/META-INF/maven/**/pom.xml";
            resource = this.findResource(archive, pattern);
            if (resource != null) {
                return resource;
            }
        }
        if (!pom.exists()) {
            pom = new ClassPathResource("META-INF/thin/empty-pom.xml");
        }
        return pom;
    }

    private void addRootArchive(List<Archive> archives, Archive archive) {
        if (!archives.isEmpty()) {
            archives.add(0, archive);
        } else {
            archives.add(archive);
        }
    }

    private List<Dependency> extract(Archive parent, Archive archive, String name, String[] profiles) {
        Resource parentPom = this.getPom(parent);
        List<Dependency> parentDependencies = this.engine.dependencies(parentPom, this.getProperties(archive, name, new String[0]));
        Resource childPom = this.getPom(archive);
        List<Dependency> childDependencies = this.engine.dependencies(childPom, this.getProperties(archive, name, profiles));
        HashMap<String, Dependency> lookup = new HashMap<String, Dependency>();
        for (Dependency dependency : parentDependencies) {
            lookup.put(this.coordinates(dependency), dependency);
        }
        for (Dependency dependency : childDependencies) {
            if (lookup.containsKey(this.coordinates(dependency))) continue;
            parentDependencies.add(dependency);
        }
        this.maybeCopyToRoot(this.root, this.getLocalRepository(), parentDependencies);
        return parentDependencies;
    }

    private void maybeCopyToRoot(String root, File repo, List<Dependency> classPathArchives) {
        if (root == null || !this.preferLocalSnapshots) {
            return;
        }
        File dir = new File(root, "repository");
        if (!dir.exists() && !dir.mkdirs() || !dir.isDirectory()) {
            throw new IllegalStateException("Cannot create root directory: " + root);
        }
        try {
            String parent = dir.getCanonicalPath();
            for (Dependency archive : classPathArchives) {
                File file;
                String path;
                if (!archive.getArtifact().isSnapshot() || !(path = (file = archive.getArtifact().getFile()).getCanonicalPath()).endsWith(".jar")) continue;
                if (!file.getCanonicalFile().toPath().startsWith(parent)) {
                    throw new IllegalStateException("Not in thin root repository: " + path);
                }
                String jar = path.substring(parent.length());
                File source = new File(repo, jar);
                File target = file;
                if (!source.exists() || FileUtils.contentEquals(source, target)) continue;
                log.info("Preferring local snapshot: " + archive);
                FileUtils.deleteDirectory(target.getParentFile());
                target.getParentFile().mkdirs();
                StreamUtils.copy(new FileInputStream(source), (OutputStream)new FileOutputStream(target));
                String pom = jar.substring(0, jar.length() - 4) + ".pom";
                file = new File(repo, pom);
                if (!file.exists()) continue;
                StreamUtils.copy(new FileInputStream(file), (OutputStream)new FileOutputStream(new File(dir, pom)));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot copy jar files", e);
        }
    }

    private String coordinates(Dependency dependency) {
        return dependency.getArtifact().getGroupId() + ":" + dependency.getArtifact().getArtifactId();
    }

    public List<Dependency> extract(Archive archive, String name, String[] profiles) {
        Properties properties = this.getProperties(archive, name, profiles);
        Resource pom = this.getPom(archive);
        log.info("Extracting dependencies from: {}, with profiles {}", (Object)pom, (Object)Arrays.asList(profiles));
        List<Dependency> dependencies = this.engine.dependencies(pom, properties);
        this.maybeCopyToRoot(this.root, this.getLocalRepository(), dependencies);
        return dependencies;
    }

    private Properties getProperties(Archive archive, String name, String[] profiles) {
        String values;
        Properties properties = new Properties();
        this.loadThinProperties(properties, archive, name, profiles);
        this.loadThinProperties(properties, this.locations, name, profiles);
        if (profiles != null && profiles.length > 0 && (values = StringUtils.arrayToCommaDelimitedString(profiles)).length() > 0) {
            properties.setProperty("thin.profile", values);
        }
        if (this.root != null) {
            properties.setProperty("thin.root", this.root);
        }
        if (this.libs != null) {
            properties.setProperty("thin.libs", this.libs);
        }
        if (this.offline) {
            properties.setProperty("thin.offline", "true");
        }
        if (this.force) {
            properties.remove("computed");
        }
        this.addOverrideProperties(properties);
        return properties;
    }

    private void addOverrideProperties(Properties properties) {
        properties.putAll((Map<?, ?>)this.overrides);
    }

    private Properties loadThinProperties(Properties props, Archive archive, String name, String[] list) {
        ArrayList<String> profiles = new ArrayList<String>(Arrays.asList(list));
        if (!profiles.contains("")) {
            profiles.add(0, "");
        }
        for (String profile : profiles) {
            String path = name + ("".equals(profile) ? "" : "-") + profile + ".properties";
            this.loadProperties(props, archive, path);
        }
        return props;
    }

    private void loadThinProperties(Properties props, String[] locations, String name, String[] profiles) {
        for (String profile : profiles) {
            String path = name + ("".equals(profile) ? "" : "-") + profile + ".properties";
            for (String location : locations) {
                try {
                    if (!location.endsWith("/")) {
                        location = location + "/";
                    }
                    this.loadProperties(props, location, path);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot load properties", e);
                }
            }
        }
    }

    private void loadProperties(Properties props, Archive archive, String path) {
        try {
            this.loadProperties(props, archive.getUrl().toString(), path);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load properties", e);
        }
    }

    private Properties loadProperties(Properties props, String url, String path) {
        log.info("Searching for properties in: " + url);
        Properties added = new Properties();
        try {
            Resource resource = this.resources.getResource(url).createRelative("META-INF/" + path);
            if (resource.exists()) {
                log.info("Loading properties from: " + resource);
                PropertiesLoaderUtils.fillProperties(added, resource);
            }
            if ((resource = this.resources.getResource(url).createRelative("/" + path)).exists()) {
                log.info("Loading properties from: " + resource);
                PropertiesLoaderUtils.fillProperties(added, resource);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load properties", e);
        }
        if (!added.isEmpty()) {
            this.merge(props, added);
        }
        return props;
    }

    private void merge(Properties props, Properties added) {
        String name;
        if (!props.isEmpty()) {
            for (Object key : new HashSet<Object>(added.keySet())) {
                String artifact;
                name = (String)key;
                if (name.startsWith("dependencies.")) {
                    artifact = name.substring("dependencies.".length());
                    if (!props.containsKey("exclusions." + artifact)) continue;
                    props.remove("exclusions." + artifact);
                    continue;
                }
                if (!name.startsWith("exclusions.")) continue;
                artifact = name.substring("exclusions.".length());
                if (!props.containsKey("dependencies." + artifact)) continue;
                props.remove("dependencies." + artifact);
            }
        }
        if ("true".equals(props.get("computed"))) {
            if (!"true".equals(added.get("computed"))) {
                for (Object key : new HashSet<Object>(added.keySet())) {
                    name = (String)key;
                    if (!name.startsWith("dependencies.") && !name.startsWith("boms.")) continue;
                    added.remove(key);
                }
            }
        } else if ("true".equals(added.get("computed"))) {
            for (Object key : new HashSet<Object>(props.keySet())) {
                name = (String)key;
                if (!name.startsWith("dependencies.") && !name.startsWith("boms.")) continue;
                props.remove(key);
            }
        }
        props.putAll((Map<?, ?>)added);
    }

    private List<Archive> archives(List<Dependency> dependencies) {
        ArrayList<Archive> list = new ArrayList<Archive>();
        for (Dependency dependency : dependencies) {
            File file = dependency.getArtifact().getFile();
            if (file == null) continue;
            try {
                list.add(new UrlArchive(file.toURI().toURL()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot locate archive: " + file, e);
            }
        }
        return list;
    }

    private Resource findResource(Archive archive, String pattern) {
        try {
            for (Resource resource : ResourcePatternUtils.getResourcePatternResolver(new DefaultResourceLoader()).getResources(archive.getUrl() + pattern)) {
                if (!resource.exists() || resource.getFilename() != null && resource.getFilename().contains("org.springframework.boot.experimental/spring-boot-thin-wrapper")) continue;
                return resource;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String extractArtifactId(Archive archive) throws MalformedURLException {
        String path = archive.getUrl().getPath();
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - 2);
        }
        path = StringUtils.getFilename(path);
        path = path.replace(".jar", "");
        path = path.split("-[0-9]")[0];
        return path;
    }

    public File getLocalRepository() {
        return DependencyResolver.instance().getLocalRepository();
    }

    public void setPreferLocalSnapshots(boolean preferLocalSnapshots) {
        this.preferLocalSnapshots = preferLocalSnapshots;
    }
}

