/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.sisu.plexus;

import hidden.com.google.inject.Guice;
import hidden.com.google.inject.Module;
import hidden.org.eclipse.sisu.inject.BindingPublisher;
import hidden.org.eclipse.sisu.inject.InjectorBindings;
import hidden.org.eclipse.sisu.inject.MutableBeanLocator;
import hidden.org.eclipse.sisu.launch.BundleModule;
import hidden.org.eclipse.sisu.launch.BundlePlan;
import hidden.org.eclipse.sisu.plexus.PlexusSpaceModule;
import hidden.org.eclipse.sisu.space.BeanScanning;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class PlexusBundlePlan
implements BundlePlan {
    private static final String SUPPORT_BUNDLE_NAME = FrameworkUtil.getBundle(PlexusSpaceModule.class).getSymbolicName();
    protected final MutableBeanLocator locator;

    public PlexusBundlePlan(MutableBeanLocator locator) {
        this.locator = locator;
    }

    @Override
    public BindingPublisher prepare(Bundle bundle) {
        if (!SUPPORT_BUNDLE_NAME.equals(bundle.getSymbolicName()) && (PlexusBundlePlan.hasPlexusAnnotations(bundle) || PlexusBundlePlan.hasPlexusXml(bundle))) {
            return new InjectorBindings(Guice.createInjector(new BundleModule(bundle, this.locator){

                @Override
                protected Module spaceModule() {
                    return new PlexusSpaceModule(this.space, BeanScanning.select(this.getProperties()));
                }
            }));
        }
        return null;
    }

    protected static boolean hasPlexusAnnotations(Bundle bundle) {
        String imports = (String)bundle.getHeaders().get("Import-Package");
        return imports != null && imports.contains("org.codehaus.plexus.component.annotations");
    }

    protected static boolean hasPlexusXml(Bundle bundle) {
        return bundle.findEntries("META-INF/plexus", "components.xml", false) != null;
    }
}

