/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.aether.internal.impl;

import hidden.org.eclipse.aether.spi.log.Logger;
import hidden.org.eclipse.aether.spi.log.NullLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Map;
import java.util.Properties;

class TrackingFileManager {
    private Logger logger = NullLoggerFactory.LOGGER;

    TrackingFileManager() {
    }

    public TrackingFileManager setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLoggerFactory.LOGGER;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Properties read(File file) {
        Object object = this.getLock(file);
        synchronized (object) {
            Properties properties;
            FileInputStream stream;
            FileLock lock;
            block8: {
                lock = null;
                stream = null;
                if (file.exists()) break block8;
                Properties properties2 = null;
                this.release(lock, file);
                this.close(stream, file);
                return properties2;
            }
            try {
                stream = new FileInputStream(file);
                lock = this.lock(stream.getChannel(), Math.max(1L, file.length()), true);
                Properties props = new Properties();
                props.load(stream);
                properties = props;
                this.release(lock, file);
                this.close(stream, file);
            }
            catch (IOException e) {
                try {
                    this.logger.warn("Failed to read tracking file " + file, e);
                    this.release(lock, file);
                    this.close(stream, file);
                }
                catch (Throwable throwable) {
                    this.release(lock, file);
                    this.close(stream, file);
                    throw throwable;
                }
            }
            return properties;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties update(File file, Map<String, String> updates) {
        Properties props = new Properties();
        Object object = this.getLock(file);
        synchronized (object) {
            File directory = file.getParentFile();
            if (!directory.mkdirs() && !directory.exists()) {
                this.logger.warn("Failed to create parent directories for tracking file " + file);
                return props;
            }
            RandomAccessFile raf = null;
            FileLock lock = null;
            try {
                raf = new RandomAccessFile(file, "rw");
                lock = this.lock(raf.getChannel(), Math.max(1L, raf.length()), false);
                if (file.canRead()) {
                    byte[] buffer = new byte[(int)raf.length()];
                    raf.readFully(buffer);
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    props.load(stream);
                }
                for (Map.Entry<String, String> update : updates.entrySet()) {
                    if (update.getValue() == null) {
                        props.remove(update.getKey());
                        continue;
                    }
                    props.setProperty(update.getKey(), update.getValue());
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                this.logger.debug("Writing tracking file " + file);
                props.store(stream, "NOTE: This is a Maven Resolver internal implementation file, its format can be changed without prior notice.");
                raf.seek(0L);
                raf.write(stream.toByteArray());
                raf.setLength(raf.getFilePointer());
                this.release(lock, file);
                this.close(raf, file);
            }
            catch (IOException e) {
                try {
                    this.logger.warn("Failed to write tracking file " + file, e);
                    this.release(lock, file);
                    this.close(raf, file);
                }
                catch (Throwable throwable) {
                    this.release(lock, file);
                    this.close(raf, file);
                    throw throwable;
                }
            }
        }
        return props;
    }

    private void release(FileLock lock, File file) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (IOException e) {
                this.logger.warn("Error releasing lock for tracking file " + file, e);
            }
        }
    }

    private void close(Closeable closeable, File file) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.logger.warn("Error closing tracking file " + file, e);
            }
        }
    }

    private Object getLock(File file) {
        try {
            return file.getCanonicalPath().intern();
        }
        catch (IOException e) {
            this.logger.warn("Failed to canonicalize path " + file + ": " + e.getMessage());
            return file.getAbsolutePath().intern();
        }
    }

    private FileLock lock(FileChannel channel, long size, boolean shared) throws IOException {
        FileLock lock = null;
        for (int attempts = 8; attempts >= 0; --attempts) {
            try {
                lock = channel.lock(0L, size, shared);
                break;
            }
            catch (OverlappingFileLockException e) {
                if (attempts <= 0) {
                    throw (IOException)new IOException().initCause(e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        if (lock == null) {
            throw new IOException("Could not lock file");
        }
        return lock;
    }
}

