/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.aether.internal.impl;

import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.impl.LocalRepositoryProvider;
import hidden.org.eclipse.aether.internal.impl.PrioritizedComponent;
import hidden.org.eclipse.aether.internal.impl.PrioritizedComponents;
import hidden.org.eclipse.aether.internal.impl.Utils;
import hidden.org.eclipse.aether.repository.LocalRepository;
import hidden.org.eclipse.aether.repository.LocalRepositoryManager;
import hidden.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import hidden.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import hidden.org.eclipse.aether.spi.locator.Service;
import hidden.org.eclipse.aether.spi.locator.ServiceLocator;
import hidden.org.eclipse.aether.spi.log.Logger;
import hidden.org.eclipse.aether.spi.log.LoggerFactory;
import hidden.org.eclipse.aether.spi.log.NullLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DefaultLocalRepositoryProvider
implements LocalRepositoryProvider,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private Collection<LocalRepositoryManagerFactory> managerFactories = new ArrayList<LocalRepositoryManagerFactory>();

    public DefaultLocalRepositoryProvider() {
    }

    @Inject
    DefaultLocalRepositoryProvider(Set<LocalRepositoryManagerFactory> factories, LoggerFactory loggerFactory) {
        this.setLocalRepositoryManagerFactories(factories);
        this.setLoggerFactory(loggerFactory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setLocalRepositoryManagerFactories(locator.getServices(LocalRepositoryManagerFactory.class));
    }

    public DefaultLocalRepositoryProvider setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public DefaultLocalRepositoryProvider addLocalRepositoryManagerFactory(LocalRepositoryManagerFactory factory) {
        this.managerFactories.add(Objects.requireNonNull(factory, "local repository manager factory cannot be null"));
        return this;
    }

    public DefaultLocalRepositoryProvider setLocalRepositoryManagerFactories(Collection<LocalRepositoryManagerFactory> factories) {
        this.managerFactories = factories == null ? new ArrayList<LocalRepositoryManagerFactory>(2) : factories;
        return this;
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        PrioritizedComponents<LocalRepositoryManagerFactory> factories = new PrioritizedComponents<LocalRepositoryManagerFactory>(session);
        for (LocalRepositoryManagerFactory factory : this.managerFactories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoLocalRepositoryManagerException> errors = new ArrayList<NoLocalRepositoryManagerException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                LocalRepositoryManager localRepositoryManager = ((LocalRepositoryManagerFactory)factory.getComponent()).newInstance(session, repository);
                if (this.logger.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using manager ").append(localRepositoryManager.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, localRepositoryManager);
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(repository.getBasedir());
                    this.logger.debug(buffer.toString());
                }
                return localRepositoryManager;
            }
            catch (NoLocalRepositoryManagerException noLocalRepositoryManagerException) {
                errors.add(noLocalRepositoryManagerException);
            }
        }
        if (this.logger.isDebugEnabled() && errors.size() > 1) {
            String msg = "Could not obtain local repository manager for " + repository;
            for (Exception exception : errors) {
                this.logger.debug(msg, exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No local repository managers registered");
        } else {
            buffer.append("Cannot access ").append(repository.getBasedir());
            buffer.append(" with type ").append(repository.getContentType());
            buffer.append(" using the available factories ");
            factories.list(buffer);
        }
        throw new NoLocalRepositoryManagerException(repository, buffer.toString(), errors.size() == 1 ? (NoLocalRepositoryManagerException)errors.get(0) : null);
    }
}

