/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.sisu.wire;

import hidden.com.google.inject.Binder;
import hidden.com.google.inject.Binding;
import hidden.com.google.inject.Key;
import hidden.com.google.inject.spi.DefaultElementVisitor;
import hidden.com.google.inject.spi.Element;
import hidden.org.eclipse.sisu.inject.Logs;
import hidden.org.eclipse.sisu.wire.DependencyVerifier;
import java.util.HashSet;
import java.util.Set;

final class ElementMerger
extends DefaultElementVisitor<Void> {
    private final DependencyVerifier verifier = new DependencyVerifier();
    private final Set<Key<?>> localKeys = new HashSet();
    private final Binder binder;

    ElementMerger(Binder binder) {
        this.binder = binder;
    }

    @Override
    public <T> Void visit(Binding<T> binding) {
        Key<T> key = binding.getKey();
        if (!this.localKeys.contains(key)) {
            if (Boolean.TRUE.equals(binding.acceptTargetVisitor(this.verifier))) {
                this.localKeys.add(key);
                binding.applyTo(this.binder);
            } else {
                Logs.trace("Discard binding: {}", binding, null);
            }
        }
        return null;
    }

    @Override
    public Void visitOther(Element element) {
        element.applyTo(this.binder);
        return null;
    }
}

