/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.aether.deployment;

import hidden.org.eclipse.aether.artifact.Artifact;
import hidden.org.eclipse.aether.deployment.DeployRequest;
import hidden.org.eclipse.aether.metadata.Metadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public final class DeployResult {
    private final DeployRequest request;
    private Collection<Artifact> artifacts;
    private Collection<Metadata> metadata;

    public DeployResult(DeployRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("deploy request has not been specified");
        }
        this.request = request;
        this.artifacts = Collections.emptyList();
        this.metadata = Collections.emptyList();
    }

    public DeployRequest getRequest() {
        return this.request;
    }

    public Collection<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public DeployResult setArtifacts(Collection<Artifact> artifacts) {
        this.artifacts = artifacts == null ? Collections.emptyList() : artifacts;
        return this;
    }

    public DeployResult addArtifact(Artifact artifact) {
        if (artifact != null) {
            if (this.artifacts.isEmpty()) {
                this.artifacts = new ArrayList<Artifact>();
            }
            this.artifacts.add(artifact);
        }
        return this;
    }

    public Collection<Metadata> getMetadata() {
        return this.metadata;
    }

    public DeployResult setMetadata(Collection<Metadata> metadata) {
        this.metadata = metadata == null ? Collections.emptyList() : metadata;
        return this;
    }

    public DeployResult addMetadata(Metadata metadata) {
        if (metadata != null) {
            if (this.metadata.isEmpty()) {
                this.metadata = new ArrayList<Metadata>();
            }
            this.metadata.add(metadata);
        }
        return this;
    }

    public String toString() {
        return this.getArtifacts() + ", " + this.getMetadata();
    }
}

