/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.repository.legacy.resolver.transform;

import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.artifact.repository.RepositoryRequest;
import hidden.org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import hidden.org.apache.maven.artifact.repository.metadata.Versioning;
import hidden.org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import hidden.org.apache.maven.artifact.resolver.ArtifactResolutionException;
import hidden.org.apache.maven.repository.legacy.resolver.transform.AbstractVersionTransformation;
import hidden.org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformation;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ArtifactTransformation.class, hint="latest")
public class LatestArtifactTransformation
extends AbstractVersionTransformation {
    @Override
    public void transformForResolve(Artifact artifact, RepositoryRequest request) throws ArtifactResolutionException, ArtifactNotFoundException {
        if ("LATEST".equals(artifact.getVersion())) {
            try {
                String version = this.resolveVersion(artifact, request);
                if ("LATEST".equals(version)) {
                    throw new ArtifactNotFoundException("Unable to determine the latest version", artifact);
                }
                artifact.setBaseVersion(version);
                artifact.updateVersion(version, request.getLocalRepository());
            }
            catch (RepositoryMetadataResolutionException e) {
                throw new ArtifactResolutionException(e.getMessage(), artifact, e);
            }
        }
    }

    @Override
    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) {
    }

    @Override
    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) {
    }

    @Override
    protected String constructVersion(Versioning versioning, String baseVersion) {
        return versioning.getLatest();
    }
}

