/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.repository.legacy.resolver.transform;

import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import hidden.org.apache.maven.artifact.installer.ArtifactInstallationException;
import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.artifact.repository.RepositoryRequest;
import hidden.org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import hidden.org.apache.maven.artifact.resolver.ArtifactResolutionException;
import hidden.org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformation;
import hidden.org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformationManager;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ArtifactTransformationManager.class)
public class DefaultArtifactTransformationManager
implements ArtifactTransformationManager {
    @Requirement(role=ArtifactTransformation.class, hints={"release", "latest", "snapshot"})
    private List<ArtifactTransformation> artifactTransformations;

    @Override
    public void transformForResolve(Artifact artifact, RepositoryRequest request) throws ArtifactResolutionException, ArtifactNotFoundException {
        for (ArtifactTransformation transform : this.artifactTransformations) {
            transform.transformForResolve(artifact, request);
        }
    }

    @Override
    public void transformForResolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        for (ArtifactTransformation transform : this.artifactTransformations) {
            transform.transformForResolve(artifact, remoteRepositories, localRepository);
        }
    }

    @Override
    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        for (ArtifactTransformation transform : this.artifactTransformations) {
            transform.transformForInstall(artifact, localRepository);
        }
    }

    @Override
    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        for (ArtifactTransformation transform : this.artifactTransformations) {
            transform.transformForDeployment(artifact, remoteRepository, localRepository);
        }
    }

    @Override
    public List<ArtifactTransformation> getArtifactTransformations() {
        return this.artifactTransformations;
    }
}

