/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.plugin.internal;

import hidden.org.apache.maven.RepositoryUtils;
import hidden.org.apache.maven.model.Dependency;
import hidden.org.apache.maven.model.Plugin;
import hidden.org.apache.maven.plugin.PluginResolutionException;
import hidden.org.apache.maven.plugin.internal.PlexusUtilsInjector;
import hidden.org.apache.maven.plugin.internal.PluginDependenciesResolver;
import hidden.org.apache.maven.plugin.internal.WagonExcluder;
import hidden.org.eclipse.aether.DefaultRepositorySystemSession;
import hidden.org.eclipse.aether.RepositorySystem;
import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.RequestTrace;
import hidden.org.eclipse.aether.artifact.Artifact;
import hidden.org.eclipse.aether.artifact.DefaultArtifact;
import hidden.org.eclipse.aether.collection.CollectRequest;
import hidden.org.eclipse.aether.collection.DependencyCollectionException;
import hidden.org.eclipse.aether.collection.DependencyGraphTransformer;
import hidden.org.eclipse.aether.collection.DependencySelector;
import hidden.org.eclipse.aether.graph.DependencyFilter;
import hidden.org.eclipse.aether.graph.DependencyNode;
import hidden.org.eclipse.aether.graph.DependencyVisitor;
import hidden.org.eclipse.aether.repository.RemoteRepository;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorException;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorResult;
import hidden.org.eclipse.aether.resolution.ArtifactRequest;
import hidden.org.eclipse.aether.resolution.ArtifactResolutionException;
import hidden.org.eclipse.aether.resolution.DependencyRequest;
import hidden.org.eclipse.aether.resolution.DependencyResolutionException;
import hidden.org.eclipse.aether.util.filter.AndDependencyFilter;
import hidden.org.eclipse.aether.util.filter.ScopeDependencyFilter;
import hidden.org.eclipse.aether.util.graph.selector.AndDependencySelector;
import hidden.org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import hidden.org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import java.util.LinkedHashMap;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=PluginDependenciesResolver.class)
public class DefaultPluginDependenciesResolver
implements PluginDependenciesResolver {
    private static final String REPOSITORY_CONTEXT = "plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repoSystem;

    private Artifact toArtifact(Plugin plugin, RepositorySystemSession session) {
        return new DefaultArtifact(plugin.getGroupId(), plugin.getArtifactId(), null, "jar", plugin.getVersion(), session.getArtifactTypeRegistry().get("maven-plugin"));
    }

    @Override
    public Artifact resolve(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        RequestTrace trace = RequestTrace.newChild(null, plugin);
        Artifact pluginArtifact = this.toArtifact(plugin, session);
        try {
            DefaultRepositorySystemSession pluginSession = new DefaultRepositorySystemSession(session);
            pluginSession.setArtifactDescriptorPolicy(new SimpleArtifactDescriptorPolicy(true, false));
            ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace);
            ArtifactDescriptorResult result = this.repoSystem.readArtifactDescriptor(pluginSession, request);
            pluginArtifact = result.getArtifact();
            String requiredMavenVersion = (String)result.getProperties().get("prerequisites.maven");
            if (requiredMavenVersion != null) {
                LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(pluginArtifact.getProperties());
                props.put("requiredMavenVersion", requiredMavenVersion);
                pluginArtifact = pluginArtifact.setProperties(props);
            }
        }
        catch (ArtifactDescriptorException e) {
            throw new PluginResolutionException(plugin, (Throwable)e);
        }
        try {
            ArtifactRequest request = new ArtifactRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace);
            pluginArtifact = this.repoSystem.resolveArtifact(session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new PluginResolutionException(plugin, (Throwable)e);
        }
        return pluginArtifact;
    }

    public DependencyNode resolveCoreExtension(Plugin plugin, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        return this.resolveInternal(plugin, null, dependencyFilter, null, repositories, session);
    }

    @Override
    public DependencyNode resolve(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        return this.resolveInternal(plugin, pluginArtifact, dependencyFilter, new PlexusUtilsInjector(), repositories, session);
    }

    private DependencyNode resolveInternal(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, DependencyGraphTransformer transformer, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        DependencyNode node;
        RequestTrace trace = RequestTrace.newChild(null, plugin);
        if (pluginArtifact == null) {
            pluginArtifact = this.toArtifact(plugin, session);
        }
        ScopeDependencyFilter collectionFilter = new ScopeDependencyFilter("provided", "test");
        DependencyFilter resolutionFilter = AndDependencyFilter.newInstance(collectionFilter, dependencyFilter);
        try {
            DependencySelector selector = AndDependencySelector.newInstance(session.getDependencySelector(), new WagonExcluder());
            transformer = ChainedDependencyGraphTransformer.newInstance(session.getDependencyGraphTransformer(), transformer);
            DefaultRepositorySystemSession pluginSession = new DefaultRepositorySystemSession(session);
            pluginSession.setDependencySelector(selector);
            pluginSession.setDependencyGraphTransformer(transformer);
            CollectRequest request = new CollectRequest();
            request.setRequestContext(REPOSITORY_CONTEXT);
            request.setRepositories(repositories);
            request.setRoot(new hidden.org.eclipse.aether.graph.Dependency(pluginArtifact, null));
            for (Dependency dependency : plugin.getDependencies()) {
                hidden.org.eclipse.aether.graph.Dependency pluginDep = RepositoryUtils.toDependency(dependency, session.getArtifactTypeRegistry());
                if (!"system".equals(pluginDep.getScope())) {
                    pluginDep = pluginDep.setScope("runtime");
                }
                request.addDependency(pluginDep);
            }
            DependencyRequest depRequest = new DependencyRequest(request, resolutionFilter);
            depRequest.setTrace(trace);
            request.setTrace(RequestTrace.newChild(trace, depRequest));
            node = this.repoSystem.collectDependencies(pluginSession, request).getRoot();
            if (this.logger.isDebugEnabled()) {
                node.accept(new GraphLogger());
            }
            depRequest.setRoot(node);
            this.repoSystem.resolveDependencies(session, depRequest);
        }
        catch (DependencyCollectionException e) {
            throw new PluginResolutionException(plugin, (Throwable)e);
        }
        catch (DependencyResolutionException e) {
            throw new PluginResolutionException(plugin, e.getCause());
        }
        return node;
    }

    class GraphLogger
    implements DependencyVisitor {
        private String indent = "";

        GraphLogger() {
        }

        @Override
        public boolean visitEnter(DependencyNode node) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.indent);
            hidden.org.eclipse.aether.graph.Dependency dep = node.getDependency();
            if (dep != null) {
                Artifact art = dep.getArtifact();
                buffer.append(art);
                buffer.append(':').append(dep.getScope());
            }
            DefaultPluginDependenciesResolver.this.logger.debug(buffer.toString());
            this.indent = this.indent + "   ";
            return true;
        }

        @Override
        public boolean visitLeave(DependencyNode node) {
            this.indent = this.indent.substring(0, this.indent.length() - 3);
            return true;
        }
    }
}

