/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.artifact.repository.metadata;

import hidden.org.apache.maven.artifact.metadata.ArtifactMetadata;
import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.artifact.repository.DefaultArtifactRepository;
import hidden.org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import hidden.org.eclipse.aether.RepositoryException;
import hidden.org.eclipse.aether.metadata.AbstractMetadata;
import hidden.org.eclipse.aether.metadata.MergeableMetadata;
import hidden.org.eclipse.aether.metadata.Metadata;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.codehaus.plexus.util.FileUtils;

public final class MetadataBridge
extends AbstractMetadata
implements MergeableMetadata {
    private ArtifactMetadata metadata;
    private boolean merged;

    public MetadataBridge(ArtifactMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void merge(File current, File result) throws RepositoryException {
        try {
            if (current.exists()) {
                FileUtils.copyFile(current, result);
            }
            MetadataRepository localRepo = new MetadataRepository(result);
            this.metadata.storeInLocalRepository(localRepo, localRepo);
            this.merged = true;
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isMerged() {
        return this.merged;
    }

    @Override
    public String getGroupId() {
        return this.emptify(this.metadata.getGroupId());
    }

    @Override
    public String getArtifactId() {
        return this.metadata.storedInGroupDirectory() ? "" : this.emptify(this.metadata.getArtifactId());
    }

    @Override
    public String getVersion() {
        return this.metadata.storedInArtifactVersionDirectory() ? this.emptify(this.metadata.getBaseVersion()) : "";
    }

    @Override
    public String getType() {
        return this.metadata.getRemoteFilename();
    }

    private String emptify(String string) {
        return string != null ? string : "";
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public MetadataBridge setFile(File file) {
        return this;
    }

    @Override
    public Metadata.Nature getNature() {
        if (this.metadata instanceof RepositoryMetadata) {
            switch (((RepositoryMetadata)this.metadata).getNature()) {
                case 3: {
                    return Metadata.Nature.RELEASE_OR_SNAPSHOT;
                }
                case 2: {
                    return Metadata.Nature.SNAPSHOT;
                }
            }
            return Metadata.Nature.RELEASE;
        }
        return Metadata.Nature.RELEASE;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public Metadata setProperties(Map<String, String> properties) {
        return this;
    }

    static class MetadataRepository
    extends DefaultArtifactRepository {
        private File metadataFile;

        public MetadataRepository(File metadataFile) {
            super("local", "", null);
            this.metadataFile = metadataFile;
        }

        @Override
        public String getBasedir() {
            return this.metadataFile.getParent();
        }

        @Override
        public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
            return this.metadataFile.getName();
        }
    }
}

