/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.artifact.manager;

import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.artifact.manager.WagonManager;
import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import hidden.org.apache.maven.execution.MavenExecutionRequest;
import hidden.org.apache.maven.execution.MavenSession;
import hidden.org.apache.maven.plugin.LegacySupport;
import hidden.org.apache.maven.repository.MirrorSelector;
import hidden.org.apache.maven.settings.Mirror;
import hidden.org.apache.maven.settings.Proxy;
import hidden.org.apache.maven.settings.Server;
import hidden.org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import hidden.org.apache.maven.settings.crypto.SettingsDecrypter;
import hidden.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import hidden.org.apache.maven.wagon.ResourceDoesNotExistException;
import hidden.org.apache.maven.wagon.TransferFailedException;
import hidden.org.apache.maven.wagon.authentication.AuthenticationInfo;
import hidden.org.apache.maven.wagon.proxy.ProxyInfo;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=WagonManager.class)
public class DefaultWagonManager
extends hidden.org.apache.maven.repository.legacy.DefaultWagonManager
implements WagonManager {
    @Requirement
    private Logger log;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private SettingsDecrypter settingsDecrypter;
    @Requirement
    private MirrorSelector mirrorSelector;
    @Requirement
    private ArtifactRepositoryFactory artifactRepositoryFactory;

    @Override
    public AuthenticationInfo getAuthenticationInfo(String id) {
        List<Server> servers;
        MavenExecutionRequest request;
        MavenSession session = this.legacySupport.getSession();
        if (session != null && id != null && (request = session.getRequest()) != null && (servers = request.getServers()) != null) {
            for (Server server : servers) {
                if (!id.equalsIgnoreCase(server.getId())) continue;
                SettingsDecryptionResult result = this.settingsDecrypter.decrypt(new DefaultSettingsDecryptionRequest(server));
                server = result.getServer();
                AuthenticationInfo authInfo = new AuthenticationInfo();
                authInfo.setUserName(server.getUsername());
                authInfo.setPassword(server.getPassword());
                authInfo.setPrivateKey(server.getPrivateKey());
                authInfo.setPassphrase(server.getPassphrase());
                return authInfo;
            }
        }
        return new AuthenticationInfo();
    }

    @Override
    public ProxyInfo getProxy(String protocol) {
        List<Proxy> proxies;
        MavenExecutionRequest request;
        MavenSession session = this.legacySupport.getSession();
        if (session != null && protocol != null && (request = session.getRequest()) != null && (proxies = request.getProxies()) != null) {
            for (Proxy proxy : proxies) {
                if (!proxy.isActive() || !protocol.equalsIgnoreCase(proxy.getProtocol())) continue;
                SettingsDecryptionResult result = this.settingsDecrypter.decrypt(new DefaultSettingsDecryptionRequest(proxy));
                proxy = result.getProxy();
                ProxyInfo proxyInfo = new ProxyInfo();
                proxyInfo.setHost(proxy.getHost());
                proxyInfo.setType(proxy.getProtocol());
                proxyInfo.setPort(proxy.getPort());
                proxyInfo.setNonProxyHosts(proxy.getNonProxyHosts());
                proxyInfo.setUserName(proxy.getUsername());
                proxyInfo.setPassword(proxy.getPassword());
                return proxyInfo;
            }
        }
        return null;
    }

    @Override
    public void getArtifact(Artifact artifact, ArtifactRepository repository) throws TransferFailedException, ResourceDoesNotExistException {
        this.getArtifact(artifact, repository, null, false);
    }

    @Override
    public void getArtifact(Artifact artifact, List<ArtifactRepository> remoteRepositories) throws TransferFailedException, ResourceDoesNotExistException {
        this.getArtifact(artifact, remoteRepositories, null, false);
    }

    @Override
    @Deprecated
    public ArtifactRepository getMirrorRepository(ArtifactRepository repository) {
        Mirror mirror = this.mirrorSelector.getMirror(repository, this.legacySupport.getSession().getSettings().getMirrors());
        if (mirror != null) {
            String id = mirror.getId();
            if (id == null) {
                id = repository.getId();
            }
            this.log.debug("Using mirror: " + mirror.getUrl() + " (id: " + id + ")");
            repository = this.artifactRepositoryFactory.createArtifactRepository(id, mirror.getUrl(), repository.getLayout(), repository.getSnapshots(), repository.getReleases());
        }
        return repository;
    }
}

