/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.artifact.deployer;

import hidden.org.apache.maven.RepositoryUtils;
import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.artifact.deployer.ArtifactDeployer;
import hidden.org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import hidden.org.apache.maven.artifact.metadata.ArtifactMetadata;
import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.artifact.repository.DefaultArtifactRepository;
import hidden.org.apache.maven.artifact.repository.LegacyLocalRepositoryManager;
import hidden.org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import hidden.org.apache.maven.artifact.repository.metadata.MetadataBridge;
import hidden.org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import hidden.org.apache.maven.plugin.LegacySupport;
import hidden.org.apache.maven.project.artifact.ProjectArtifactMetadata;
import hidden.org.eclipse.aether.RepositorySystem;
import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.RequestTrace;
import hidden.org.eclipse.aether.deployment.DeployRequest;
import hidden.org.eclipse.aether.deployment.DeployResult;
import hidden.org.eclipse.aether.deployment.DeploymentException;
import hidden.org.eclipse.aether.metadata.MergeableMetadata;
import hidden.org.eclipse.aether.metadata.Metadata;
import hidden.org.eclipse.aether.repository.RemoteRepository;
import hidden.org.eclipse.aether.util.artifact.SubArtifact;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=ArtifactDeployer.class, instantiationStrategy="per-lookup")
public class DefaultArtifactDeployer
extends AbstractLogEnabled
implements ArtifactDeployer {
    @Requirement
    private RepositorySystem repoSystem;
    @Requirement
    private LegacySupport legacySupport;
    private Map<Object, MergeableMetadata> relatedMetadata = new ConcurrentHashMap<Object, MergeableMetadata>();

    @Override
    @Deprecated
    public void deploy(String basedir, String finalName, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        String extension = artifact.getArtifactHandler().getExtension();
        File source = new File(basedir, finalName + "." + extension);
        this.deploy(source, artifact, deploymentRepository, localRepository);
    }

    @Override
    public void deploy(File source, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        DeployResult result;
        RepositorySystemSession session = LegacyLocalRepositoryManager.overlay(localRepository, this.legacySupport.getRepositorySession(), this.repoSystem);
        DeployRequest request = new DeployRequest();
        request.setTrace(RequestTrace.newChild(null, this.legacySupport.getSession().getCurrentProject()));
        hidden.org.eclipse.aether.artifact.Artifact mainArtifact = RepositoryUtils.toArtifact(artifact);
        mainArtifact = mainArtifact.setFile(source);
        request.addArtifact(mainArtifact);
        String versionKey = artifact.getGroupId() + ':' + artifact.getArtifactId();
        String snapshotKey = null;
        if (artifact.isSnapshot()) {
            snapshotKey = versionKey + ':' + artifact.getBaseVersion();
            request.addMetadata(this.relatedMetadata.get(snapshotKey));
        }
        request.addMetadata(this.relatedMetadata.get(versionKey));
        for (ArtifactMetadata metadata : artifact.getMetadataList()) {
            if (metadata instanceof ProjectArtifactMetadata) {
                hidden.org.eclipse.aether.artifact.Artifact pomArtifact = new SubArtifact(mainArtifact, "", "pom");
                pomArtifact = pomArtifact.setFile(((ProjectArtifactMetadata)metadata).getFile());
                request.addArtifact(pomArtifact);
                continue;
            }
            if (metadata instanceof SnapshotArtifactRepositoryMetadata || metadata instanceof ArtifactRepositoryMetadata) continue;
            request.addMetadata(new MetadataBridge(metadata));
        }
        RemoteRepository remoteRepo = RepositoryUtils.toRepo(deploymentRepository);
        if (deploymentRepository instanceof DefaultArtifactRepository && deploymentRepository.getAuthentication() == null) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(remoteRepo);
            builder.setAuthentication(session.getAuthenticationSelector().getAuthentication(remoteRepo));
            builder.setProxy(session.getProxySelector().getProxy(remoteRepo));
            remoteRepo = builder.build();
        }
        request.setRepository(remoteRepo);
        try {
            result = this.repoSystem.deploy(session, request);
        }
        catch (DeploymentException e) {
            throw new ArtifactDeploymentException(e.getMessage(), e);
        }
        for (Metadata metadata : result.getMetadata()) {
            if (metadata.getClass().getName().endsWith(".internal.VersionsMetadata")) {
                this.relatedMetadata.put(versionKey, (MergeableMetadata)metadata);
            }
            if (snapshotKey == null || !metadata.getClass().getName().endsWith(".internal.RemoteSnapshotMetadata")) continue;
            this.relatedMetadata.put(snapshotKey, (MergeableMetadata)metadata);
        }
        artifact.setResolvedVersion(result.getArtifacts().iterator().next().getVersion());
    }
}

