/*
 * Decompiled with CFR 0.152.
 */
package hidden.com.google.inject.internal;

import hidden.com.google.common.base.Preconditions;
import hidden.com.google.common.collect.ImmutableList;
import hidden.com.google.common.collect.ImmutableMap;
import hidden.com.google.common.collect.ListMultimap;
import hidden.com.google.common.collect.Lists;
import hidden.com.google.common.collect.Maps;
import hidden.com.google.inject.Key;
import hidden.com.google.inject.Provider;
import hidden.com.google.inject.ProvisionException;
import hidden.com.google.inject.Scope;
import hidden.com.google.inject.Scopes;
import hidden.com.google.inject.internal.ConstructionContext;
import hidden.com.google.inject.internal.CycleDetectingLock;
import hidden.com.google.inject.internal.Errors;
import hidden.com.google.inject.internal.ErrorsException;
import hidden.com.google.inject.internal.InjectorImpl;
import hidden.com.google.inject.internal.InternalContext;
import hidden.com.google.inject.spi.Dependency;
import hidden.com.google.inject.spi.DependencyAndSource;
import hidden.com.google.inject.spi.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SingletonScope
implements Scope {
    private static final Object NULL = new Object();
    private static final CycleDetectingLock.CycleDetectingLockFactory<Key<?>> cycleDetectingLockFactory = new CycleDetectingLock.CycleDetectingLockFactory();

    @Override
    public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
        return new Provider<T>(){
            volatile Object instance;
            final ConstructionContext<T> constructionContext = new ConstructionContext();
            final CycleDetectingLock<Key<?>> creationLock = SingletonScope.access$000().create(key);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public T get() {
                initialInstance = this.instance;
                if (initialInstance == null) {
                    locksCycle = this.creationLock.lockOrDetectPotentialLocksCycle();
                    if (locksCycle.isEmpty()) {
                        try {
                            if (this.instance != null) ** GOTO lbl54
                            provided = creator.get();
                            v0 = providedNotNull = provided == null ? SingletonScope.access$100() : provided;
                            if (this.instance == null) {
                                if (Scopes.isCircularProxy(provided)) {
                                    var5_8 = provided;
                                    return var5_8;
                                }
                                var5_9 = this.constructionContext;
                                synchronized (var5_9) {
                                    this.instance = providedNotNull;
                                    this.constructionContext.setProxyDelegates(provided);
                                }
                            }
                            Preconditions.checkState(this.instance == providedNotNull, "Singleton is called recursively returning different results");
                        }
                        catch (RuntimeException e) {
                            providedNotNull = this.constructionContext;
                            synchronized (providedNotNull) {
                                this.constructionContext.finishConstruction();
                            }
                            throw e;
                        }
                        finally {
                            this.creationLock.unlock();
                        }
                    } else {
                        e = this.constructionContext;
                        synchronized (e) {
                            if (this.instance == null) {
                                globalInternalContext = InjectorImpl.getGlobalInternalContext();
                                internalContext = globalInternalContext.get(Thread.currentThread());
                                dependency = Preconditions.checkNotNull(internalContext.getDependency(), "globalInternalContext.get(currentThread()).getDependency()");
                                rawType = dependency.getKey().getTypeLiteral().getRawType();
                                try {
                                    proxy = this.constructionContext.createProxy(new Errors(), internalContext.getInjectorOptions(), rawType);
                                    return (T)proxy;
                                }
                                catch (ErrorsException e) {
                                    exceptionErrorMessages = e.getErrors().getMessages();
                                    Preconditions.checkState(exceptionErrorMessages.size() == 1);
                                    cycleDependenciesMessage = this.createCycleDependenciesMessage(ImmutableMap.copyOf(globalInternalContext), locksCycle, exceptionErrorMessages.get(0));
                                    throw new ProvisionException(ImmutableList.of(cycleDependenciesMessage, exceptionErrorMessages.get(0)));
                                }
                            }
                        }
                    }
lbl54:
                    // 4 sources

                    initializedInstance = this.instance;
                    Preconditions.checkState(initializedInstance != null, "Internal error: Singleton is not initialized contrary to our expectations");
                    initializedTypedInstance = initializedInstance;
                    return (T)(initializedInstance == SingletonScope.access$100() ? null : initializedTypedInstance);
                }
                typedInitialIntance = initialInstance;
                return (T)(initialInstance == SingletonScope.access$100() ? null : typedInitialIntance);
            }

            private Message createCycleDependenciesMessage(Map<Thread, InternalContext> globalInternalContext, ListMultimap<Long, Key<?>> locksCycle, Message proxyCreationError) {
                ArrayList<Object> sourcesCycle = Lists.newArrayList();
                sourcesCycle.add(Thread.currentThread());
                HashMap<Long, Thread> threadById = Maps.newHashMap();
                for (Thread thread : globalInternalContext.keySet()) {
                    threadById.put(thread.getId(), thread);
                }
                Iterator<Thread> i$ = locksCycle.keySet().iterator();
                while (i$.hasNext()) {
                    long lockedThreadId = (Long)((Object)i$.next());
                    Thread lockedThread = (Thread)threadById.get(lockedThreadId);
                    List<Key<?>> lockedKeys = Collections.unmodifiableList(locksCycle.get(lockedThreadId));
                    if (lockedThread == null) continue;
                    List<DependencyAndSource> dependencyChain = null;
                    boolean allLockedKeysAreFoundInDependencies = false;
                    InternalContext lockedThreadInternalContext = globalInternalContext.get(lockedThread);
                    if (lockedThreadInternalContext != null) {
                        dependencyChain = lockedThreadInternalContext.getDependencyChain();
                        LinkedList<Key<?>> lockedKeysToFind = Lists.newLinkedList(lockedKeys);
                        for (DependencyAndSource d : dependencyChain) {
                            Dependency<?> dependency = d.getDependency();
                            if (dependency == null || !dependency.getKey().equals(lockedKeysToFind.get(0))) continue;
                            lockedKeysToFind.remove(0);
                            if (!lockedKeysToFind.isEmpty()) continue;
                            allLockedKeysAreFoundInDependencies = true;
                            break;
                        }
                    }
                    if (allLockedKeysAreFoundInDependencies) {
                        Key<?> firstLockedKey = lockedKeys.get(0);
                        boolean firstLockedKeyFound = false;
                        for (DependencyAndSource d : dependencyChain) {
                            Dependency<?> dependency = d.getDependency();
                            if (dependency == null) continue;
                            if (firstLockedKeyFound) {
                                sourcesCycle.add(dependency);
                                sourcesCycle.add(d.getBindingSource());
                                continue;
                            }
                            if (!dependency.getKey().equals(firstLockedKey)) continue;
                            firstLockedKeyFound = true;
                            sourcesCycle.add(d.getBindingSource());
                        }
                    } else {
                        sourcesCycle.addAll(lockedKeys);
                    }
                    sourcesCycle.add(lockedThread);
                }
                return new Message(sourcesCycle, String.format("Encountered circular dependency spanning several threads. %s", proxyCreationError.getMessage()), null);
            }

            public String toString() {
                return String.format("%s[%s]", creator, Scopes.SINGLETON);
            }
        };
    }

    @Override
    public String toString() {
        return "Scopes.SINGLETON";
    }

    static /* synthetic */ CycleDetectingLock.CycleDetectingLockFactory access$000() {
        return cycleDetectingLockFactory;
    }

    static /* synthetic */ Object access$100() {
        return NULL;
    }
}

