/*
 * Decompiled with CFR 0.152.
 */
package hidden.com.google.inject.internal;

import hidden.com.google.common.base.Objects;
import hidden.com.google.common.collect.ImmutableSet;
import hidden.com.google.inject.Binder;
import hidden.com.google.inject.Injector;
import hidden.com.google.inject.Key;
import hidden.com.google.inject.internal.BindingImpl;
import hidden.com.google.inject.internal.InjectorImpl;
import hidden.com.google.inject.internal.InternalFactory;
import hidden.com.google.inject.internal.Scoping;
import hidden.com.google.inject.spi.BindingTargetVisitor;
import hidden.com.google.inject.spi.Dependency;
import hidden.com.google.inject.spi.ExposedBinding;
import hidden.com.google.inject.spi.PrivateElements;
import java.util.Set;

public final class ExposedBindingImpl<T>
extends BindingImpl<T>
implements ExposedBinding<T> {
    private final PrivateElements privateElements;

    public ExposedBindingImpl(InjectorImpl injector, Object source, Key<T> key, InternalFactory<T> factory, PrivateElements privateElements) {
        super(injector, key, source, factory, Scoping.UNSCOPED);
        this.privateElements = privateElements;
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return ImmutableSet.of(Dependency.get(Key.get(Injector.class)));
    }

    @Override
    public PrivateElements getPrivateElements() {
        return this.privateElements;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(ExposedBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("privateElements", this.privateElements).toString();
    }

    @Override
    public void applyTo(Binder binder) {
        throw new UnsupportedOperationException("This element represents a synthetic binding.");
    }
}

