/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.partition;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.job.Job;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.listener.StepExecutionListener;
import org.springframework.batch.core.partition.Partitioner;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.Step;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.core.step.builder.FlowStepBuilder;
import org.springframework.batch.core.step.builder.JobStepBuilder;
import org.springframework.batch.core.step.builder.PartitionStepBuilder;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.builder.TaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.integration.partition.BeanFactoryStepLocator;
import org.springframework.batch.integration.partition.StepExecutionRequestHandler;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.StandardIntegrationFlow;
import org.springframework.integration.dsl.context.IntegrationFlowContext;
import org.springframework.messaging.MessageChannel;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class RemotePartitioningWorkerStepBuilder
extends StepBuilder {
    private static final String SERVICE_ACTIVATOR_METHOD_NAME = "handle";
    private static final Log logger = LogFactory.getLog(RemotePartitioningWorkerStepBuilder.class);
    private MessageChannel inputChannel;
    private MessageChannel outputChannel;
    private StepLocator stepLocator;
    private BeanFactory beanFactory;

    public RemotePartitioningWorkerStepBuilder(String name, JobRepository jobRepository) {
        super(name, jobRepository);
    }

    public RemotePartitioningWorkerStepBuilder inputChannel(MessageChannel inputChannel) {
        Assert.notNull((Object)inputChannel, (String)"inputChannel must not be null");
        this.inputChannel = inputChannel;
        return this;
    }

    public RemotePartitioningWorkerStepBuilder outputChannel(MessageChannel outputChannel) {
        Assert.notNull((Object)outputChannel, (String)"outputChannel must not be null");
        this.outputChannel = outputChannel;
        return this;
    }

    public RemotePartitioningWorkerStepBuilder stepLocator(StepLocator stepLocator) {
        Assert.notNull((Object)stepLocator, (String)"stepLocator must not be null");
        this.stepLocator = stepLocator;
        return this;
    }

    public RemotePartitioningWorkerStepBuilder beanFactory(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"beanFactory must not be null");
        this.beanFactory = beanFactory;
        return this;
    }

    public RemotePartitioningWorkerStepBuilder startLimit(int startLimit) {
        super.startLimit(startLimit);
        return this;
    }

    public RemotePartitioningWorkerStepBuilder listener(Object listener) {
        super.listener(listener);
        return this;
    }

    public RemotePartitioningWorkerStepBuilder listener(StepExecutionListener listener) {
        super.listener(listener);
        return this;
    }

    public RemotePartitioningWorkerStepBuilder allowStartIfComplete(boolean allowStartIfComplete) {
        super.allowStartIfComplete(allowStartIfComplete);
        return this;
    }

    public TaskletStepBuilder tasklet(Tasklet tasklet, PlatformTransactionManager transactionManager) {
        this.configureWorkerIntegrationFlow();
        return super.tasklet(tasklet, transactionManager);
    }

    public <I, O> SimpleStepBuilder<I, O> chunk(int chunkSize, PlatformTransactionManager transactionManager) {
        this.configureWorkerIntegrationFlow();
        return super.chunk(chunkSize, transactionManager);
    }

    public <I, O> SimpleStepBuilder<I, O> chunk(CompletionPolicy completionPolicy, PlatformTransactionManager transactionManager) {
        this.configureWorkerIntegrationFlow();
        return super.chunk(completionPolicy, transactionManager);
    }

    public PartitionStepBuilder partitioner(String stepName, Partitioner partitioner) {
        this.configureWorkerIntegrationFlow();
        return super.partitioner(stepName, partitioner);
    }

    public PartitionStepBuilder partitioner(Step step) {
        this.configureWorkerIntegrationFlow();
        return super.partitioner(step);
    }

    public JobStepBuilder job(Job job) {
        this.configureWorkerIntegrationFlow();
        return super.job(job);
    }

    public FlowStepBuilder flow(Flow flow) {
        this.configureWorkerIntegrationFlow();
        return super.flow(flow);
    }

    private void configureWorkerIntegrationFlow() {
        Assert.notNull((Object)this.inputChannel, (String)"An InputChannel must be provided");
        if (this.stepLocator == null) {
            BeanFactoryStepLocator beanFactoryStepLocator = new BeanFactoryStepLocator();
            beanFactoryStepLocator.setBeanFactory(this.beanFactory);
            this.stepLocator = beanFactoryStepLocator;
        }
        if (this.outputChannel == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"The output channel is set to a NullChannel. The manager step must poll the job repository for workers status.");
            }
            this.outputChannel = new NullChannel();
        }
        StepExecutionRequestHandler stepExecutionRequestHandler = new StepExecutionRequestHandler();
        stepExecutionRequestHandler.setJobRepository(this.getJobRepository());
        stepExecutionRequestHandler.setStepLocator(this.stepLocator);
        StandardIntegrationFlow standardIntegrationFlow = ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)this.inputChannel).handle((Object)stepExecutionRequestHandler, SERVICE_ACTIVATOR_METHOD_NAME)).channel(this.outputChannel)).get();
        IntegrationFlowContext integrationFlowContext = (IntegrationFlowContext)this.beanFactory.getBean(IntegrationFlowContext.class);
        integrationFlowContext.registration((IntegrationFlow)standardIntegrationFlow).autoStartup(false).register();
    }
}

