/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.config.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.integration.launch.JobLaunchingGateway;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JobLaunchingGatewayParser
extends AbstractConsumerEndpointParser {
    private static final Log logger = LogFactory.getLog(JobLaunchingGatewayParser.class);

    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder jobLaunchingGatewayBuilder = BeanDefinitionBuilder.genericBeanDefinition(JobLaunchingGateway.class);
        String jobOperator = element.getAttribute("job-operator");
        if (StringUtils.hasText((String)jobOperator)) {
            jobLaunchingGatewayBuilder.addConstructorArgReference(jobOperator);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No jobOperator specified, using default 'jobOperator' reference instead.");
            }
            jobLaunchingGatewayBuilder.addConstructorArgReference("jobOperator");
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jobLaunchingGatewayBuilder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        String replyChannel = element.getAttribute("reply-channel");
        if (StringUtils.hasText((String)replyChannel)) {
            jobLaunchingGatewayBuilder.addPropertyReference("outputChannel", replyChannel);
        }
        return jobLaunchingGatewayBuilder;
    }
}

