/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.launch;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.integration.launch.JobLaunchRequest;
import org.springframework.batch.integration.launch.JobLaunchingMessageHandler;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobLaunchingGateway
extends AbstractReplyProducingMessageHandler {
    private final JobLaunchingMessageHandler jobLaunchingMessageHandler;

    public JobLaunchingGateway(JobLauncher jobLauncher) {
        Assert.notNull((Object)jobLauncher, (String)"jobLauncher must not be null.");
        this.jobLaunchingMessageHandler = new JobLaunchingMessageHandler(jobLauncher);
    }

    protected Object handleRequestMessage(Message<?> requestMessage) throws MessageHandlingException {
        JobExecution jobExecution;
        Assert.notNull(requestMessage, (String)"The provided requestMessage must not be null.");
        Object payload = requestMessage.getPayload();
        Assert.isInstanceOf(JobLaunchRequest.class, (Object)payload, (String)"The payload must be of type JobLaunchRequest.");
        JobLaunchRequest jobLaunchRequest = (JobLaunchRequest)payload;
        try {
            jobExecution = this.jobLaunchingMessageHandler.launch(jobLaunchRequest);
        }
        catch (JobExecutionException e) {
            throw new MessageHandlingException(requestMessage, (Throwable)e);
        }
        return jobExecution;
    }
}

