/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file.mapping;

import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.file.LineMapper;
import org.springframework.batch.infrastructure.item.file.mapping.FieldSetMapper;
import org.springframework.batch.infrastructure.item.file.transform.LineTokenizer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultLineMapper<T>
implements LineMapper<T>,
InitializingBean {
    private @Nullable LineTokenizer tokenizer;
    private @Nullable FieldSetMapper<T> fieldSetMapper;

    @Override
    public T mapLine(String line, int lineNumber) throws Exception {
        return this.fieldSetMapper.mapFieldSet(this.tokenizer.tokenize(line));
    }

    public void setLineTokenizer(LineTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public void setFieldSetMapper(FieldSetMapper<T> fieldSetMapper) {
        this.fieldSetMapper = fieldSetMapper;
    }

    public void afterPropertiesSet() {
        Assert.state((this.tokenizer != null ? 1 : 0) != 0, (String)"The LineTokenizer must be set");
        Assert.state((this.fieldSetMapper != null ? 1 : 0) != 0, (String)"The FieldSetMapper must be set");
    }
}

