/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file.mapping;

import java.util.Map;
import org.springframework.batch.infrastructure.item.file.LineMapper;
import org.springframework.batch.infrastructure.item.file.mapping.FieldSetMapper;
import org.springframework.batch.infrastructure.item.file.transform.LineTokenizer;
import org.springframework.batch.infrastructure.item.file.transform.PatternMatchingCompositeLineTokenizer;
import org.springframework.batch.infrastructure.support.PatternMatcher;
import org.springframework.util.Assert;

public class PatternMatchingCompositeLineMapper<T>
implements LineMapper<T> {
    private final PatternMatchingCompositeLineTokenizer tokenizer;
    private PatternMatcher<FieldSetMapper<T>> patternMatcher;

    public PatternMatchingCompositeLineMapper(Map<String, LineTokenizer> tokenizers, Map<String, FieldSetMapper<T>> fieldSetMappers) {
        Assert.isTrue((!tokenizers.isEmpty() ? 1 : 0) != 0, (String)"The 'tokenizers' property must be non-empty");
        Assert.isTrue((!fieldSetMappers.isEmpty() ? 1 : 0) != 0, (String)"The 'fieldSetMappers' property must be non-empty");
        this.tokenizer = new PatternMatchingCompositeLineTokenizer(tokenizers);
        this.patternMatcher = new PatternMatcher<FieldSetMapper<T>>(fieldSetMappers);
    }

    @Override
    public T mapLine(String line, int lineNumber) throws Exception {
        return this.patternMatcher.match(line).mapFieldSet(this.tokenizer.tokenize(line));
    }

    public void setTokenizers(Map<String, LineTokenizer> tokenizers) {
        this.tokenizer.setTokenizers(tokenizers);
    }

    public void setFieldSetMappers(Map<String, FieldSetMapper<T>> fieldSetMappers) {
        Assert.isTrue((!fieldSetMappers.isEmpty() ? 1 : 0) != 0, (String)"The 'fieldSetMappers' property must be non-empty");
        this.patternMatcher = new PatternMatcher<FieldSetMapper<T>>(fieldSetMappers);
    }
}

