/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file.separator;

import org.springframework.batch.infrastructure.item.file.separator.DefaultRecordSeparatorPolicy;

public class SuffixRecordSeparatorPolicy
extends DefaultRecordSeparatorPolicy {
    public static final String DEFAULT_SUFFIX = ";";
    private String suffix = ";";
    private boolean ignoreWhitespace = true;

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
    }

    @Override
    public boolean isEndOfRecord(String line) {
        String trimmed = this.ignoreWhitespace ? line.trim() : line;
        return trimmed.endsWith(this.suffix);
    }

    @Override
    public String postProcess(String record) {
        return record.substring(0, record.lastIndexOf(this.suffix));
    }
}

