/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.support;

import java.util.function.Function;
import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.batch.infrastructure.item.ExecutionContext;
import org.springframework.batch.infrastructure.item.ItemStream;
import org.springframework.batch.infrastructure.item.ItemStreamException;
import org.springframework.batch.infrastructure.item.ItemStreamWriter;
import org.springframework.batch.infrastructure.item.ItemWriter;

public class MappingItemWriter<T, U>
implements ItemStreamWriter<T> {
    private final Function<? super T, ? extends U> mapper;
    private final ItemWriter<? super U> downstream;

    public MappingItemWriter(Function<? super T, ? extends U> mapper, ItemWriter<? super U> downstream) {
        this.mapper = mapper;
        this.downstream = downstream;
    }

    @Override
    public void write(Chunk<? extends T> chunk) throws Exception {
        this.downstream.write(new Chunk<U>(chunk.getItems().stream().map(this.mapper).toList()));
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        ItemWriter<? super U> itemWriter = this.downstream;
        if (itemWriter instanceof ItemStream) {
            ItemStream itemStream = (ItemStream)((Object)itemWriter);
            itemStream.open(executionContext);
        }
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        ItemWriter<? super U> itemWriter = this.downstream;
        if (itemWriter instanceof ItemStream) {
            ItemStream itemStream = (ItemStream)((Object)itemWriter);
            itemStream.update(executionContext);
        }
    }

    @Override
    public void close() throws ItemStreamException {
        ItemWriter<? super U> itemWriter = this.downstream;
        if (itemWriter instanceof ItemStream) {
            ItemStream itemStream = (ItemStream)((Object)itemWriter);
            itemStream.close();
        }
    }
}

