/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.json;

import java.io.InputStream;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ParseException;
import org.springframework.batch.infrastructure.item.json.JsonObjectReader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.json.JsonMapper;

public class JacksonJsonObjectReader<T>
implements JsonObjectReader<T> {
    private final Class<? extends T> itemType;
    private JsonMapper mapper;
    private @Nullable JsonParser jsonParser;
    private @Nullable InputStream inputStream;

    public JacksonJsonObjectReader(Class<? extends T> itemType) {
        this(new JsonMapper(), itemType);
    }

    public JacksonJsonObjectReader(JsonMapper mapper, Class<? extends T> itemType) {
        this.mapper = mapper;
        this.itemType = itemType;
    }

    public void setMapper(JsonMapper mapper) {
        Assert.notNull((Object)mapper, (String)"The mapper must not be null");
        this.mapper = mapper;
    }

    @Override
    public void open(Resource resource) throws Exception {
        Assert.notNull((Object)resource, (String)"The resource must not be null");
        this.inputStream = resource.getInputStream();
        this.jsonParser = this.mapper.createParser(this.inputStream);
        Assert.state((this.jsonParser.nextToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (String)"The Json input stream must start with an array of Json objects");
    }

    @Override
    public @Nullable T read() throws Exception {
        try {
            if (this.jsonParser.nextToken() == JsonToken.START_OBJECT) {
                return (T)this.mapper.readValue(this.jsonParser, this.itemType);
            }
        }
        catch (JacksonException e) {
            throw new ParseException("Unable to read next JSON object", e);
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        this.inputStream.close();
        this.jsonParser.close();
    }

    @Override
    public void jumpToItem(int itemIndex) throws Exception {
        for (int i = 0; i < itemIndex; ++i) {
            if (this.jsonParser.nextToken() != JsonToken.START_OBJECT) continue;
            this.jsonParser.skipChildren();
        }
    }
}

