/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.jms;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.batch.infrastructure.item.ItemWriter;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.util.Assert;

public class JmsItemWriter<T>
implements ItemWriter<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private JmsOperations jmsTemplate;

    public JmsItemWriter(JmsOperations jmsTemplate) {
        Assert.notNull((Object)jmsTemplate, (String)"jmsTemplate must not be null");
        this.jmsTemplate = jmsTemplate;
        if (jmsTemplate instanceof JmsTemplate) {
            JmsTemplate template = (JmsTemplate)jmsTemplate;
            Assert.isTrue((template.getDefaultDestination() != null || template.getDefaultDestinationName() != null ? 1 : 0) != 0, (String)"JmsTemplate must have a defaultDestination or defaultDestinationName!");
        }
    }

    public void setJmsTemplate(JmsOperations jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
        if (jmsTemplate instanceof JmsTemplate) {
            JmsTemplate template = (JmsTemplate)jmsTemplate;
            Assert.isTrue((template.getDefaultDestination() != null || template.getDefaultDestinationName() != null ? 1 : 0) != 0, (String)"JmsTemplate must have a defaultDestination or defaultDestinationName!");
        }
    }

    @Override
    public void write(Chunk<? extends T> items) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Writing to JMS with " + items.size() + " items."));
        }
        for (Object item : items) {
            this.jmsTemplate.convertAndSend(item);
        }
    }
}

