/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file.transform;

import java.util.ArrayList;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.file.transform.FieldExtractor;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;

public class BeanWrapperFieldExtractor<T>
implements FieldExtractor<T> {
    private String[] names;

    public BeanWrapperFieldExtractor(String ... names) {
        this.names = names;
    }

    public void setNames(String[] names) {
        Assert.notNull((Object)names, (String)"Names must be non-null");
        this.names = (String[])names.clone();
    }

    @Override
    public Object[] extract(T item) {
        ArrayList<@Nullable Object> values = new ArrayList<Object>();
        BeanWrapperImpl bw = new BeanWrapperImpl(item);
        for (String propertyName : this.names) {
            values.add(bw.getPropertyValue(propertyName));
        }
        return values.toArray();
    }
}

