/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.database.support;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.incrementer.AbstractColumnMaxValueIncrementer;

class SqliteMaxValueIncrementer
extends AbstractColumnMaxValueIncrementer {
    public SqliteMaxValueIncrementer(DataSource dataSource, String incrementerName, String columnName) {
        super(dataSource, incrementerName, columnName);
    }

    protected long getNextKey() {
        Connection con = DataSourceUtils.getConnection((DataSource)this.getDataSource());
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            DataSourceUtils.applyTransactionTimeout((Statement)stmt, (DataSource)this.getDataSource());
            stmt.executeUpdate("insert into " + this.getIncrementerName() + " values(null)");
            ResultSet rs = stmt.executeQuery("select max(rowid) from " + this.getIncrementerName());
            if (!rs.next()) {
                throw new DataAccessResourceFailureException("rowid query failed after executing an update");
            }
            long nextKey = rs.getLong(1);
            stmt.executeUpdate("delete from " + this.getIncrementerName() + " where " + this.getColumnName() + " < " + nextKey);
            long l = nextKey;
            return l;
        }
        catch (SQLException ex) {
            throw new DataAccessResourceFailureException("Could not obtain rowid", (Throwable)ex);
        }
        finally {
            JdbcUtils.closeStatement((Statement)stmt);
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.getDataSource());
        }
    }
}

