/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.avro.builder;

import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.avro.AvroItemReader;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AvroItemReaderBuilder<T> {
    private boolean saveState = true;
    private String name = AvroItemReader.class.getSimpleName();
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;
    private @Nullable Resource schema;
    private @Nullable Resource resource;
    private @Nullable Class<T> type;
    private boolean embeddedSchema = true;

    public AvroItemReaderBuilder<T> resource(Resource resource) {
        Assert.notNull((Object)resource, (String)"A 'resource' is required.");
        Assert.state((boolean)resource.exists(), (String)("Resource " + resource.getFilename() + " does not exist."));
        this.resource = resource;
        return this;
    }

    public AvroItemReaderBuilder<T> schema(Resource schema) {
        Assert.notNull((Object)schema, (String)"A 'schema' Resource is required.");
        Assert.state((boolean)schema.exists(), (String)("Resource " + schema.getFilename() + " does not exist."));
        this.schema = schema;
        return this;
    }

    public AvroItemReaderBuilder<T> schema(String schemaString) {
        Assert.hasText((String)schemaString, (String)"A 'schema' is required.");
        this.schema = new ByteArrayResource(schemaString.getBytes());
        return this;
    }

    public AvroItemReaderBuilder<T> type(Class<T> type) {
        Assert.notNull(type, (String)"A 'type' is required.");
        this.type = type;
        return this;
    }

    public AvroItemReaderBuilder<T> embeddedSchema(boolean embeddedSchema) {
        this.embeddedSchema = embeddedSchema;
        return this;
    }

    public AvroItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public AvroItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public AvroItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public AvroItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public AvroItemReader<T> build() {
        AvroItemReader<T> avroItemReader;
        Assert.notNull((Object)this.resource, (String)"A 'resource' is required.");
        if (this.type != null) {
            Assert.isNull((Object)this.schema, (String)"You cannot specify a schema and 'type'.");
            avroItemReader = new AvroItemReader<T>(this.resource, this.type);
        } else {
            Assert.notNull((Object)this.schema, (String)"'schema' is required.");
            avroItemReader = new AvroItemReader(this.resource, this.schema);
        }
        avroItemReader.setSaveState(this.saveState);
        if (this.saveState) {
            Assert.state((boolean)StringUtils.hasText((String)this.name), (String)"A name is required when saveState is set to true.");
        }
        avroItemReader.setName(this.name);
        avroItemReader.setCurrentItemCount(this.currentItemCount);
        avroItemReader.setMaxItemCount(this.maxItemCount);
        avroItemReader.setEmbeddedSchema(this.embeddedSchema);
        return avroItemReader;
    }
}

