/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file.builder;

import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.file.MultiResourceItemWriter;
import org.springframework.batch.infrastructure.item.file.ResourceAwareItemWriterItemStream;
import org.springframework.batch.infrastructure.item.file.ResourceSuffixCreator;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class MultiResourceItemWriterBuilder<T> {
    private @Nullable Resource resource;
    private @Nullable ResourceAwareItemWriterItemStream<? super T> delegate;
    private int itemCountLimitPerResource = Integer.MAX_VALUE;
    private @Nullable ResourceSuffixCreator suffixCreator;
    private boolean saveState = true;
    private @Nullable String name;

    public MultiResourceItemWriterBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public MultiResourceItemWriterBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public MultiResourceItemWriterBuilder<T> resourceSuffixCreator(ResourceSuffixCreator suffixCreator) {
        this.suffixCreator = suffixCreator;
        return this;
    }

    public MultiResourceItemWriterBuilder<T> itemCountLimitPerResource(int itemCountLimitPerResource) {
        this.itemCountLimitPerResource = itemCountLimitPerResource;
        return this;
    }

    public MultiResourceItemWriterBuilder<T> delegate(ResourceAwareItemWriterItemStream<? super T> delegate) {
        this.delegate = delegate;
        return this;
    }

    public MultiResourceItemWriterBuilder<T> resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public MultiResourceItemWriter<T> build() {
        Assert.notNull((Object)this.resource, (String)"resource is required.");
        Assert.notNull(this.delegate, (String)"delegate is required.");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is true.");
        }
        MultiResourceItemWriter<T> writer = new MultiResourceItemWriter<T>(this.delegate);
        writer.setResource(this.resource);
        writer.setItemCountLimitPerResource(this.itemCountLimitPerResource);
        if (this.suffixCreator != null) {
            writer.setResourceSuffixCreator(this.suffixCreator);
        }
        writer.setSaveState(this.saveState);
        if (this.name != null) {
            writer.setName(this.name);
        }
        return writer;
    }
}

